/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.internal.BaseRoute53ApiExpectTest;
import org.jclouds.route53.parse.CreateHostedZoneResponseTest;
import org.jclouds.route53.parse.GetChangeResponseTest;
import org.jclouds.route53.parse.GetHostedZoneResponseTest;
import org.jclouds.route53.parse.ListHostedZonesResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="HostedZoneApiExpectTest")
public class HostedZoneApiExpectTest
extends BaseRoute53ApiExpectTest {
    HttpRequest createWithReference = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).payload(HostedZoneApiExpectTest.payloadFromStringWithContentType((String)"<CreateHostedZoneRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><Name>jclouds.org.</Name><CallerReference>expect</CallerReference></CreateHostedZoneRequest>", (String)"application/xml"))).build();
    HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/new_zone.xml", "text/xml"))).build();
    HttpRequest createWithReferenceAndComment = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).payload(HostedZoneApiExpectTest.payloadFromStringWithContentType((String)"<CreateHostedZoneRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><Name>jclouds.org.</Name><CallerReference>expect</CallerReference><HostedZoneConfig><Comment>comment</Comment></HostedZoneConfig></CreateHostedZoneRequest>", (String)"application/xml"))).build();
    HttpRequest get = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone/Z1XTHCPEFRWV1X").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).build();
    HttpResponse getResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/hosted_zone.xml", "text/xml"))).build();
    HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).build();
    HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/hosted_zones.xml", "text/xml"))).build();
    HttpRequest listAt = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone?marker=Z333333YYYYYYY").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).build();
    HttpRequest delete = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone/Z1XTHCPEFRWV1X").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).build();
    HttpResponse deleteResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/change.xml", "text/xml"))).build();

    public void testCreateWithReferenceWhenResponseIs2xx() {
        Route53Api success = (Route53Api)this.requestSendsResponse(this.createWithReference, this.createResponse);
        Assert.assertEquals((String)success.getHostedZoneApi().createWithReference("jclouds.org.", "expect").toString(), (String)new CreateHostedZoneResponseTest().expected().toString());
    }

    public void testCreateWithReferenceAndCommentWhenResponseIs2xx() {
        Route53Api success = (Route53Api)this.requestSendsResponse(this.createWithReferenceAndComment, this.createResponse);
        Assert.assertEquals((String)success.getHostedZoneApi().createWithReferenceAndComment("jclouds.org.", "expect", "comment").toString(), (String)new CreateHostedZoneResponseTest().expected().toString());
    }

    public void testGetWhenResponseIs2xx() {
        Route53Api success = (Route53Api)this.requestSendsResponse(this.get, this.getResponse);
        Assert.assertEquals((String)success.getHostedZoneApi().get("Z1XTHCPEFRWV1X").toString(), (String)new GetHostedZoneResponseTest().expected().toString());
    }

    public void testGetWhenResponseIs404() {
        Route53Api fail = (Route53Api)this.requestSendsResponse(this.get, this.notFound);
        Assert.assertNull((Object)fail.getHostedZoneApi().get("Z1XTHCPEFRWV1X"));
    }

    public void testListWhenResponseIs2xx() {
        Route53Api success = (Route53Api)this.requestSendsResponse(this.list, this.listResponse);
        Assert.assertEquals((String)((IterableWithMarker)success.getHostedZoneApi().list().get(0)).toString(), (String)new ListHostedZonesResponseTest().expected().toString());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testListWhenResponseIs404() {
        Route53Api fail = (Route53Api)this.requestSendsResponse(this.list, this.notFound);
        Assert.assertEquals((Set)((IterableWithMarker)fail.getHostedZoneApi().list().get(0)).toSet(), (Set)ImmutableSet.of());
    }

    public void testListAtWhenResponseIs2xx() {
        Route53Api apiWhenAtExist = (Route53Api)this.requestSendsResponse(this.listAt, this.listResponse);
        Assert.assertEquals((String)apiWhenAtExist.getHostedZoneApi().listAt("Z333333YYYYYYY").toString(), (String)new ListHostedZonesResponseTest().expected().toString());
    }

    public void testList2PagesWhenResponseIs2xx() {
        HttpResponse noMore = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(HostedZoneApiExpectTest.payloadFromStringWithContentType((String)"<ListHostedZonesResponse />", (String)"text/xml"))).build();
        Route53Api success = (Route53Api)this.requestsSendResponses(this.list, this.listResponse, this.listAt, noMore);
        Assert.assertEquals((String)success.getHostedZoneApi().list().concat().toString(), (String)new ListHostedZonesResponseTest().expected().toString());
    }

    public void testDeleteWhenResponseIs2xx() {
        Route53Api success = (Route53Api)this.requestSendsResponse(this.delete, this.deleteResponse);
        Assert.assertEquals((String)success.getHostedZoneApi().delete("Z1XTHCPEFRWV1X").toString(), (String)new GetChangeResponseTest().expected().toString());
    }

    public void testDeleteWhenResponseIs404() {
        Route53Api fail = (Route53Api)this.requestSendsResponse(this.delete, this.notFound);
        Assert.assertNull((Object)fail.getHostedZoneApi().delete("Z1XTHCPEFRWV1X"));
    }
}

