/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.features;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.logging.Logger;
import org.jclouds.JcloudsVersion;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.domain.Change;
import org.jclouds.route53.domain.HostedZone;
import org.jclouds.route53.domain.NewHostedZone;
import org.jclouds.route53.features.HostedZoneApi;
import org.jclouds.route53.internal.BaseRoute53ApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="HostedZoneApiLiveTest")
public class HostedZoneApiLiveTest
extends BaseRoute53ApiLiveTest {
    private void checkHostedZone(HostedZone zone) {
        Logger.getAnonymousLogger().info(String.format("zone %s rrs: %s", zone.getName(), zone.getResourceRecordSetCount()));
        Preconditions.checkNotNull((Object)zone.getId(), (String)"Id: HostedZone %s", (Object[])new Object[]{zone});
        Preconditions.checkNotNull((Object)zone.getName(), (String)"Name: HostedZone %s", (Object[])new Object[]{zone});
        Preconditions.checkNotNull((Object)zone.getCallerReference(), (String)"CallerReference: HostedZone %s", (Object[])new Object[]{zone});
        Preconditions.checkNotNull((Object)zone.getComment(), (String)"While Comment can be null for a HostedZone, its Optional wrapper cannot %s", (Object[])new Object[]{zone});
    }

    @Test
    protected void testListHostedZones() {
        ImmutableList zones = this.api().list().concat().toList();
        Logger.getAnonymousLogger().info("zones: " + zones.size());
        for (HostedZone zone : zones) {
            this.checkHostedZone(zone);
            Assert.assertEquals((Object)this.api().get(zone.getId()).getZone(), (Object)zone);
        }
    }

    @Test
    public void testGetHostedZoneWhenNotFound() {
        Assert.assertNull((Object)this.api().get("AAAAAAAAAAAAAAAA"));
    }

    @Test
    public void testDeleteHostedZoneWhenNotFound() {
        Assert.assertNull((Object)this.api().delete("AAAAAAAAAAAAAAAA"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndDeleteHostedZone() {
        String name = System.getProperty("user.name").replace('.', '-') + ".zone.route53test.jclouds.org.";
        String nonce = name + " @ " + new Date();
        String comment = name + " for " + JcloudsVersion.get();
        NewHostedZone newHostedZone = this.api().createWithReferenceAndComment(name, nonce, comment);
        Logger.getAnonymousLogger().info("created zone: " + newHostedZone);
        try {
            this.checkHostedZone(newHostedZone.getZone());
            Assert.assertEquals((Object)newHostedZone.getChange().getStatus(), (Object)Change.Status.PENDING, (String)("invalid status on zone " + newHostedZone));
            Assert.assertTrue((newHostedZone.getNameServers().size() > 0 ? 1 : 0) != 0, (String)("no name servers for zone " + newHostedZone));
            Assert.assertEquals((String)newHostedZone.getZone().getName(), (String)name);
            Assert.assertEquals((String)newHostedZone.getZone().getCallerReference(), (String)nonce);
            Assert.assertEquals((String)((String)newHostedZone.getZone().getComment().get()), (String)comment);
            Assert.assertTrue((boolean)this.inSync.apply((Object)newHostedZone.getChange()), (String)("zone didn't sync " + newHostedZone));
        }
        finally {
            Change delete = this.api().delete(newHostedZone.getZone().getId());
            Assert.assertTrue((boolean)this.inSync.apply((Object)delete), (String)("delete didn't sync " + delete));
        }
    }

    protected HostedZoneApi api() {
        return ((Route53Api)this.api).getHostedZoneApi();
    }
}

