/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.route53.InvalidChangeBatchException;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.domain.ChangeBatch;
import org.jclouds.route53.domain.ResourceRecordSet;
import org.jclouds.route53.domain.ResourceRecordSetIterable;
import org.jclouds.route53.internal.BaseRoute53ApiExpectTest;
import org.jclouds.route53.parse.GetChangeResponseTest;
import org.jclouds.route53.parse.ListResourceRecordSetsResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ResourceResourceRecordSetApiExpectTest")
public class ResourceRecordSetApiExpectTest
extends BaseRoute53ApiExpectTest {
    HttpRequest create = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone/Z1PA6795UKMFR9/rrset").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).payload(this.payloadFromResourceWithContentType("/create_rrs_request.xml", "application/xml"))).build();
    HttpResponse jobResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/change.xml", "text/xml"))).build();
    HttpRequest apply = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone/Z1PA6795UKMFR9/rrset").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).payload(this.payloadFromResourceWithContentType("/batch_rrs_request.xml", "application/xml"))).build();
    HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone/Z1PA6795UKMFR9/rrset").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).build();
    HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/rrsets.xml", "text/xml"))).build();
    HttpRequest listAt = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone/Z1PA6795UKMFR9/rrset?name=testdoc2.example.com").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).build();
    HttpRequest listAtNameAndType = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone/Z1PA6795UKMFR9/rrset?name=testdoc2.example.com&type=NS").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).build();
    HttpRequest delete = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone/Z1PA6795UKMFR9/rrset").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).payload(this.payloadFromResourceWithContentType("/delete_rrs_request.xml", "application/xml"))).build();

    public void testCreateWhenResponseIs2xx() {
        Route53Api success = (Route53Api)this.requestSendsResponse(this.create, this.jobResponse);
        Assert.assertEquals((String)success.getResourceRecordSetApiForHostedZone("Z1PA6795UKMFR9").create(ResourceRecordSet.builder().name("jclouds.org.").type("TXT").add("my texts").build()).toString(), (String)new GetChangeResponseTest().expected().toString());
    }

    public void testApplyWhenResponseIs2xx() {
        Route53Api success = (Route53Api)this.requestSendsResponse(this.apply, this.jobResponse);
        Assert.assertEquals((String)success.getResourceRecordSetApiForHostedZone("Z1PA6795UKMFR9").apply(ChangeBatch.builder().delete(ResourceRecordSet.builder().name("jclouds.org.").type("TXT").add("my texts").build()).create(ResourceRecordSet.builder().name("jclouds.org.").type("TXT").add("my better texts").build()).build()).toString(), (String)new GetChangeResponseTest().expected().toString());
    }

    @Test(expectedExceptions={InvalidChangeBatchException.class}, expectedExceptionsMessageRegExp="\\[Tried to create resource record set duplicate.example.com. type A, but it already exists, Tried to delete resource record set noexist.example.com. type A, but it was not found\\]")
    public void testApplyWhenResponseIs4xx() {
        HttpResponse batchErrorFound = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).payload(this.payloadFromResourceWithContentType("/invalid_change_batch.xml", "application/xml"))).build();
        Route53Api fails = (Route53Api)this.requestSendsResponse(this.apply, batchErrorFound);
        fails.getResourceRecordSetApiForHostedZone("Z1PA6795UKMFR9").apply(ChangeBatch.builder().delete(ResourceRecordSet.builder().name("jclouds.org.").type("TXT").add("my texts").build()).create(ResourceRecordSet.builder().name("jclouds.org.").type("TXT").add("my better texts").build()).build());
    }

    public void testListWhenResponseIs2xx() {
        Route53Api success = (Route53Api)this.requestSendsResponse(this.list, this.listResponse);
        Assert.assertEquals((String)((IterableWithMarker)success.getResourceRecordSetApiForHostedZone("Z1PA6795UKMFR9").list().get(0)).toString(), (String)new ListResourceRecordSetsResponseTest().expected().toString());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testListWhenResponseIs404() {
        Route53Api fail = (Route53Api)this.requestSendsResponse(this.list, this.notFound);
        Assert.assertEquals((Set)((IterableWithMarker)fail.getResourceRecordSetApiForHostedZone("Z1PA6795UKMFR9").list().get(0)).toSet(), (Set)ImmutableSet.of());
    }

    public void testListAtWhenResponseIs2xx() {
        Route53Api apiWhenAtExist = (Route53Api)this.requestSendsResponse(this.listAt, this.listResponse);
        ResourceRecordSetIterable.NextRecord next = ResourceRecordSetIterable.NextRecord.name((String)"testdoc2.example.com");
        Assert.assertEquals((String)apiWhenAtExist.getResourceRecordSetApiForHostedZone("Z1PA6795UKMFR9").listAt(next).toString(), (String)new ListResourceRecordSetsResponseTest().expected().toString());
    }

    public void testListAtNameAndTypeWhenResponseIs2xx() {
        Route53Api apiWhenAtExist = (Route53Api)this.requestSendsResponse(this.listAtNameAndType, this.listResponse);
        ResourceRecordSetIterable.NextRecord next = ResourceRecordSetIterable.NextRecord.nameAndType((String)"testdoc2.example.com", (String)"NS");
        Assert.assertEquals((String)apiWhenAtExist.getResourceRecordSetApiForHostedZone("Z1PA6795UKMFR9").listAt(next).toString(), (String)new ListResourceRecordSetsResponseTest().expected().toString());
    }

    public void testList2PagesWhenResponseIs2xx() {
        HttpResponse noMore = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(ResourceRecordSetApiExpectTest.payloadFromStringWithContentType((String)"<ListResourceRecordSetsResponse />", (String)"text/xml"))).build();
        Route53Api success = (Route53Api)this.requestsSendResponses(this.list, this.listResponse, this.listAtNameAndType, noMore);
        Assert.assertEquals((Set)success.getResourceRecordSetApiForHostedZone("Z1PA6795UKMFR9").list().concat().toSet(), (Set)new ListResourceRecordSetsResponseTest().expected().toSet());
    }

    public void testDeleteWhenResponseIs2xx() {
        Route53Api success = (Route53Api)this.requestSendsResponse(this.delete, this.jobResponse);
        Assert.assertEquals((String)success.getResourceRecordSetApiForHostedZone("Z1PA6795UKMFR9").create(ResourceRecordSet.builder().name("jclouds.org.").type("TXT").ttl(0).add("my texts").build()).toString(), (String)new GetChangeResponseTest().expected().toString());
    }
}

