/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.features;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.jclouds.JcloudsVersion;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.domain.Change;
import org.jclouds.route53.domain.ChangeBatch;
import org.jclouds.route53.domain.HostedZone;
import org.jclouds.route53.domain.NewHostedZone;
import org.jclouds.route53.domain.ResourceRecordSet;
import org.jclouds.route53.features.ResourceRecordSetApi;
import org.jclouds.route53.internal.BaseRoute53ApiLiveTest;
import org.jclouds.route53.predicates.HostedZonePredicates;
import org.jclouds.route53.predicates.ResourceRecordSetPredicates;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ResourceResourceRecordSetApiLiveTest")
public class ResourceRecordSetApiLiveTest
extends BaseRoute53ApiLiveTest {
    AtomicLong zones = new AtomicLong();
    LoadingCache<String, AtomicLong> recordTypeCounts = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AtomicLong>(){

        public AtomicLong load(String key) throws Exception {
            return new AtomicLong();
        }
    });
    private static final Predicate<ResourceRecordSet> requiredRRTypes = Predicates.or((Predicate)ResourceRecordSetPredicates.typeEquals((String)"SOA"), (Predicate)ResourceRecordSetPredicates.typeEquals((String)"NS"));

    private void checkRRS(ResourceRecordSet rrs) {
        Preconditions.checkNotNull((Object)rrs.getName(), (String)"Name: ResourceRecordSet %s", (Object[])new Object[]{rrs});
        Preconditions.checkNotNull((Object)rrs.getType(), (String)"Type: ResourceRecordSet %s", (Object[])new Object[]{rrs});
        Preconditions.checkNotNull((Object)rrs.getTTL(), (String)"TTL: ResourceRecordSet %s", (Object[])new Object[]{rrs});
        Preconditions.checkNotNull((Object)rrs.getAliasTarget(), (String)"AliasTarget: ResourceRecordSet %s", (Object[])new Object[]{rrs});
        if (rrs.getAliasTarget().isPresent()) {
            Assert.assertTrue((boolean)rrs.getValues().isEmpty(), (String)("Values present on aliasTarget ResourceRecordSet: " + rrs));
        } else {
            Assert.assertTrue((!rrs.getValues().isEmpty() ? 1 : 0) != 0, (String)("Values absent on ResourceRecordSet: " + rrs));
        }
        if (rrs instanceof ResourceRecordSet.RecordSubset) {
            Preconditions.checkNotNull((Object)((ResourceRecordSet.RecordSubset)ResourceRecordSet.RecordSubset.class.cast(rrs)).getId(), (String)"Id: ResourceRecordSubset %s", (Object[])new Object[]{rrs});
        }
        if (rrs instanceof ResourceRecordSet.RecordSubset.Weighted) {
            Preconditions.checkNotNull((Object)((ResourceRecordSet.RecordSubset.Weighted)ResourceRecordSet.RecordSubset.Weighted.class.cast(rrs)).getWeight(), (String)"Weight: ResourceRecordSubset %s", (Object[])new Object[]{rrs});
        }
        if (rrs instanceof ResourceRecordSet.RecordSubset.Latency) {
            Preconditions.checkNotNull((Object)((ResourceRecordSet.RecordSubset.Latency)ResourceRecordSet.RecordSubset.Latency.class.cast(rrs)).getRegion(), (String)"Region: ResourceRecordSubset %s", (Object[])new Object[]{rrs});
        }
    }

    @Test
    private void testListRRSs() {
        for (HostedZone zone : this.zones().concat()) {
            this.zones.incrementAndGet();
            this.checkAllRRs(zone.getId());
        }
    }

    private void checkAllRRs(String zoneId) {
        HostedZone zone = ((Route53Api)this.api).getHostedZoneApi().get(zoneId).getZone();
        ImmutableList records = this.api(zone.getId()).list().concat().toList();
        Assert.assertEquals((int)zone.getResourceRecordSetCount(), (int)records.size());
        for (ResourceRecordSet rrs : records) {
            ((AtomicLong)this.recordTypeCounts.getUnchecked((Object)rrs.getType())).addAndGet(rrs.getAliasTarget().isPresent() ? 1L : (long)rrs.getValues().size());
            this.checkRRS(rrs);
        }
    }

    @AfterClass
    void logSummary() {
        Logger.getAnonymousLogger().info("zoneCount: " + this.zones);
        for (Map.Entry entry : this.recordTypeCounts.asMap().entrySet()) {
            Logger.getAnonymousLogger().info(String.format("type: %s, count: %s", entry.getKey(), entry.getValue()));
        }
    }

    @Test
    public void testDeleteRRSNotFound() {
        for (HostedZone zone : this.zones().concat()) {
            Assert.assertNull((Object)this.api(zone.getId()).delete(ResourceRecordSet.builder().name("krank.foo.bar.").type("TXT").add("kranko").build()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndDeleteBulkRecords() {
        String name = System.getProperty("user.name").replace('.', '-') + ".bulk.route53test.jclouds.org.";
        try {
            String zoneId = this.recreateZone(name);
            ImmutableList records = ImmutableList.builder().add((Object)ResourceRecordSet.builder().name("dom1." + name).type("TXT").add("\"somehow\" \" somewhere\"").build()).add((Object)ResourceRecordSet.builder().name("dom2." + name).type("TXT").add("\"goodies\"").build()).build();
            this.createAndDeleteRecordsInZone((ImmutableList<ResourceRecordSet>)records, zoneId);
        }
        finally {
            this.clearAndDeleteHostedZonesNamed(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndDeleteWeightedRecords() {
        String name = System.getProperty("user.name").replace('.', '-') + ".weight.route53test.jclouds.org.";
        try {
            String zoneId = this.recreateZone(name);
            ImmutableList records = ImmutableList.builder().add((Object)ResourceRecordSet.RecordSubset.Weighted.builder().id("dom1").weight(1).name("dom." + name).type("CNAME").add("dom1." + name).build()).add((Object)ResourceRecordSet.RecordSubset.Weighted.builder().id("dom2").weight(1).name("dom." + name).type("CNAME").add("dom2." + name).build()).build();
            this.createAndDeleteRecordsInZone((ImmutableList<ResourceRecordSet>)records, zoneId);
        }
        finally {
            this.clearAndDeleteHostedZonesNamed(name);
        }
    }

    private String recreateZone(String name) {
        this.clearAndDeleteHostedZonesNamed(name);
        String nonce = name + " @ " + new Date();
        String comment = name + " for " + JcloudsVersion.get();
        NewHostedZone newHostedZone = ((Route53Api)this.api).getHostedZoneApi().createWithReferenceAndComment(name, nonce, comment);
        Logger.getAnonymousLogger().info("created zone: " + newHostedZone);
        Assert.assertTrue((boolean)this.inSync.apply((Object)newHostedZone.getChange()), (String)("zone didn't sync " + newHostedZone));
        return newHostedZone.getZone().getId();
    }

    private void createAndDeleteRecordsInZone(ImmutableList<ResourceRecordSet> records, String zoneId) {
        this.sync(this.api(zoneId).apply(ChangeBatch.createAll(records)));
        this.checkAllRRs(zoneId);
        this.sync(this.api(zoneId).apply(ChangeBatch.deleteAll(records)));
        PagedIterable<ResourceRecordSet> refreshed = this.refresh(zoneId);
        Assert.assertTrue((boolean)refreshed.concat().filter(Predicates.not(requiredRRTypes)).isEmpty(), (String)("zone still has optional records: " + refreshed));
    }

    private void clearAndDeleteHostedZonesNamed(String name) {
        for (HostedZone zone : ((Route53Api)this.api).getHostedZoneApi().list().concat().filter(HostedZonePredicates.nameEquals((String)name))) {
            Logger.getAnonymousLogger().info("clearing and deleting zone: " + zone);
            ImmutableSet remaining = this.refresh(zone.getId()).concat().filter(Predicates.not(requiredRRTypes)).toSet();
            if (!remaining.isEmpty()) {
                this.sync(this.api(zone.getId()).apply(ChangeBatch.deleteAll((Iterable)remaining)));
            }
            this.sync(((Route53Api)this.api).getHostedZoneApi().delete(zone.getId()));
        }
    }

    private void sync(Change job) {
        Assert.assertTrue((boolean)this.inSync.apply((Object)job), (String)("job didn't sync " + job));
    }

    private PagedIterable<ResourceRecordSet> refresh(String zoneId) {
        return this.api(zoneId).list();
    }

    private PagedIterable<HostedZone> zones() {
        PagedIterable zones = ((Route53Api)this.api).getHostedZoneApi().list();
        if (((IterableWithMarker)zones.get(0)).isEmpty()) {
            throw new SkipException("no zones in context: " + this.identity);
        }
        return zones;
    }

    private ResourceRecordSetApi api(String zoneId) {
        return ((Route53Api)this.api).getResourceRecordSetApiForHostedZone(zoneId);
    }
}

