/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.handlers;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.io.Payload;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.internal.BaseRestApiExpectTest;
import org.jclouds.route53.InvalidChangeBatchException;
import org.jclouds.route53.handlers.Route53ErrorHandler;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="Route53ErrorHandlerTest")
public class Route53ErrorHandlerTest {
    Route53ErrorHandler function = (Route53ErrorHandler)Guice.createInjector((Module[])new Module[]{new SaxParserModule()}).getInstance(Route53ErrorHandler.class);
    HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://route53.amazonaws.com/2012-02-29/hostedzone/Z1PA6795UKMFR9/rrset").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).payload(this.payloadFromResource("/batch_rrs_request.xml"))).build();
    HttpCommand command = new HttpCommand(this.request);

    @Test
    public void testInvalidChangeBatchException() throws IOException {
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).payload(this.payloadFromResource("/invalid_change_batch.xml"))).build();
        this.function.handleError(this.command, response);
        InvalidChangeBatchException exception = (InvalidChangeBatchException)InvalidChangeBatchException.class.cast(this.command.getException());
        Assert.assertEquals((Collection)exception.getMessages(), (Collection)ImmutableSet.of((Object)"Tried to create resource record set duplicate.example.com. type A, but it already exists", (Object)"Tried to delete resource record set noexist.example.com. type A, but it was not found"));
    }

    @Test
    public void testDeleteNotFound() throws IOException {
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).payload(BaseRestApiExpectTest.payloadFromStringWithContentType((String)"<ErrorResponse><Error><Type>Sender</Type><Code>InvalidChangeBatch</Code><Message>Tried to delete resource record set krank.foo.bar., type TXT but it was not found</Message></Error></ErrorResponse>", (String)"application/xml"))).build();
        this.function.handleError(this.command, response);
        Assert.assertEquals(this.command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)this.command.getException().getMessage(), (String)"Tried to delete resource record set krank.foo.bar., type TXT but it was not found");
        AWSResponseException exception = (AWSResponseException)AWSResponseException.class.cast(this.command.getException().getCause());
        Assert.assertEquals((String)exception.getError().getCode(), (String)"InvalidChangeBatch");
    }

    private Payload payloadFromResource(String resource) {
        try {
            return BaseRestApiExpectTest.payloadFromStringWithContentType((String)Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream(resource)), (String)"application/xml");
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

