/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.parse;

import java.io.InputStream;
import java.util.Date;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.Change;
import org.jclouds.route53.xml.ChangeHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GetChangeResponseTest")
public class GetChangeResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/change.xml");
        Change expected = this.expected();
        ChangeHandler handler = (ChangeHandler)this.injector.getInstance(ChangeHandler.class);
        Change result = (Change)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
        Assert.assertEquals((Object)result.getStatus(), (Object)expected.getStatus());
        Assert.assertEquals((Object)result.getSubmittedAt(), (Object)expected.getSubmittedAt());
    }

    public Change expected() {
        Date submittedAt = new SimpleDateFormatDateService().iso8601DateParse("2011-09-10T01:36:41.958Z");
        return Change.create((String)"C2682N5HXP0BZ4", (Change.Status)Change.Status.INSYNC, (Date)submittedAt);
    }
}

