/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.parse;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.HostedZone;
import org.jclouds.route53.domain.HostedZoneAndNameServers;
import org.jclouds.route53.xml.GetHostedZoneResponseHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GetHostedZoneResponseTest")
public class GetHostedZoneResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/hosted_zone.xml");
        HostedZoneAndNameServers expected = this.expected();
        GetHostedZoneResponseHandler handler = (GetHostedZoneResponseHandler)this.injector.getInstance(GetHostedZoneResponseHandler.class);
        HostedZoneAndNameServers result = (HostedZoneAndNameServers)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
    }

    public HostedZoneAndNameServers expected() {
        return HostedZoneAndNameServers.create((HostedZone)HostedZone.builder().id("Z21DW1QVGID6NG").name("example.com.").callerReference("a_unique_reference").comment("Migrate an existing domain to Route 53").build(), (Iterable)ImmutableList.builder().add((Object)"ns-1638.awsdns-12.co.uk").add((Object)"ns-144.awsdns-18.com").add((Object)"ns-781.awsdns-33.net").add((Object)"ns-1478.awsdns-56.org").build());
    }
}

