/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.parse;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.HostedZone;
import org.jclouds.route53.xml.ListHostedZonesResponseHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ListHostedZonesResponseTest")
public class ListHostedZonesResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/hosted_zones.xml");
        IterableWithMarker<HostedZone> expected = this.expected();
        ListHostedZonesResponseHandler handler = (ListHostedZonesResponseHandler)this.injector.getInstance(ListHostedZonesResponseHandler.class);
        IterableWithMarker result = (IterableWithMarker)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public IterableWithMarker<HostedZone> expected() {
        return IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)HostedZone.builder().id("Z21DW1QVGID6NG").name("example.com.").callerReference("a_unique_reference").resourceRecordSetCount(17).comment("Migrate an existing domain to Route 53").build(), (Object)HostedZone.builder().id("Z2682N5HXP0BZ4").name("example2.com.").callerReference("a_unique_reference2").resourceRecordSetCount(117).comment("This is my 2nd hosted zone.").build()), (Object)"Z333333YYYYYYY");
    }
}

