/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.xml;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.HostedZone;
import org.jclouds.route53.domain.HostedZoneAndNameServers;
import org.jclouds.route53.xml.HostedZoneHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class GetHostedZoneResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<HostedZoneAndNameServers> {
    private final HostedZoneHandler zoneHandler;
    private StringBuilder currentText = new StringBuilder();
    private boolean inHostedZone;
    private HostedZone zone;
    private ImmutableList.Builder<String> nameServers = ImmutableList.builder();

    @Inject
    public GetHostedZoneResponseHandler(HostedZoneHandler zoneHandler) {
        this.zoneHandler = zoneHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostedZoneAndNameServers getResult() {
        try {
            HostedZoneAndNameServers hostedZoneAndNameServers = HostedZoneAndNameServers.create(this.zone, (Iterable<String>)this.nameServers.build());
            return hostedZoneAndNameServers;
        }
        finally {
            this.zone = null;
            this.nameServers = ImmutableList.builder();
        }
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"HostedZone")) {
            this.inHostedZone = true;
        }
        if (this.inHostedZone) {
            this.zoneHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (this.inHostedZone) {
            if (qName.equals("HostedZone")) {
                this.inHostedZone = false;
                this.zone = this.zoneHandler.getResult();
            } else {
                this.zoneHandler.endElement(uri, name, qName);
            }
        } else if (qName.equals("NameServer")) {
            this.nameServers.add((Object)SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inHostedZone) {
            this.zoneHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

