/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.internal.BaseS3AsyncClientTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindAsHostPrefixIfConfiguredNoPathTest")
public class BindAsHostPrefixIfConfiguredNoPathTest
extends BaseS3AsyncClientTest<S3AsyncClient> {
    public void testBucketWithHostnameStyle() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(S3AsyncClient.class, (String)"deleteObject", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"testbucket.example.com", (Object)"test.jpg"));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://s3.amazonaws.com/testbucket.example.com/test.jpg HTTP/1.1");
    }

    protected Properties setupProperties() {
        Properties properties = super.setupProperties();
        properties.setProperty("jclouds.s3.virtual-host-buckets", "false");
        return properties;
    }
}

