/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.s3.blobstore.functions.BlobToObjectMetadata;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.MutableObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.internal.ListBucketResponseImpl;

@Singleton
public class ResourceToBucketList
implements Function<PageSet<? extends StorageMetadata>, ListBucketResponse> {
    private final BlobToObjectMetadata blob2ObjectMd;

    @Inject
    public ResourceToBucketList(BlobToObjectMetadata blob2ObjectMd) {
        this.blob2ObjectMd = blob2ObjectMd;
    }

    public ListBucketResponse apply(PageSet<? extends StorageMetadata> list) {
        Iterable contents = Iterables.transform((Iterable)Iterables.filter(list, (Predicate)new Predicate<StorageMetadata>(){

            public boolean apply(StorageMetadata input) {
                return input.getType() == StorageType.BLOB;
            }
        }), (Function)new Function<StorageMetadata, ObjectMetadata>(){

            public MutableObjectMetadata apply(StorageMetadata from) {
                return ResourceToBucketList.this.blob2ObjectMd.apply((BlobMetadata)from);
            }
        });
        LinkedHashSet commonPrefixes = Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter(list, (Predicate)new Predicate<StorageMetadata>(){

            public boolean apply(StorageMetadata input) {
                return input.getType() == StorageType.RELATIVE_PATH;
            }
        }), (Function)new Function<StorageMetadata, String>(){

            public String apply(StorageMetadata from) {
                return from.getName();
            }
        }));
        return new ListBucketResponseImpl(null, contents, null, null, list.getNextMarker(), 0, "/", list.getNextMarker() != null, (Set)commonPrefixes);
    }
}

