/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.internal;

import java.io.IOException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.s3.S3ApiMetadata;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class BaseS3AsyncClientTest<T extends S3AsyncClient>
extends BaseAsyncClientTest<T> {
    protected BlobToObject blobToS3Object;
    protected RequestAuthorizeSignature filter;

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), RequestAuthorizeSignature.class);
    }

    @BeforeClass
    protected void setupFactory() throws IOException {
        super.setupFactory();
        this.blobToS3Object = (BlobToObject)this.injector.getInstance(BlobToObject.class);
        this.filter = (RequestAuthorizeSignature)this.injector.getInstance(RequestAuthorizeSignature.class);
    }

    public S3ApiMetadata createApiMetadata() {
        return new S3ApiMetadata();
    }
}

