/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Set;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.jclouds.s3.xml.BucketLoggingHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BucketLoggingHandlerTest")
public class BucketLoggingHandlerTest
extends BaseHandlerTest {
    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/bucket_logging.xml");
        BucketLogging expected = new BucketLogging("mylogs", "access_log-", (Iterable)ImmutableSet.of((Object)new AccessControlList.Grant((AccessControlList.Grantee)new AccessControlList.EmailAddressGrantee("adrian@jclouds.org"), "FULL_CONTROL")));
        BucketLoggingHandler handler = (BucketLoggingHandler)this.injector.getInstance(BucketLoggingHandler.class);
        BucketLogging result = (BucketLogging)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.getTargetBucket(), (String)expected.getTargetBucket());
        Assert.assertEquals((Set)result.getTargetGrants(), (Set)expected.getTargetGrants());
        Assert.assertEquals((String)result.getTargetPrefix(), (String)expected.getTargetPrefix());
    }
}

