/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Provides;
import java.io.Closeable;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.blobstore.attr.BlobScope;
import org.jclouds.blobstore.attr.BlobScopes;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.http.options.GetOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.S3Fallbacks;
import org.jclouds.s3.binders.BindACLToXMLPayload;
import org.jclouds.s3.binders.BindAsHostPrefixIfConfigured;
import org.jclouds.s3.binders.BindBucketLoggingToXmlPayload;
import org.jclouds.s3.binders.BindNoBucketLoggingToXmlPayload;
import org.jclouds.s3.binders.BindPayerToXmlPayload;
import org.jclouds.s3.binders.BindS3ObjectMetadataToRequest;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.Payer;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.fallbacks.FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.functions.AssignCorrectHostnameForBucket;
import org.jclouds.s3.functions.BindRegionToXmlPayload;
import org.jclouds.s3.functions.DefaultEndpointThenInvalidateRegion;
import org.jclouds.s3.functions.ObjectKey;
import org.jclouds.s3.functions.ParseObjectFromHeadersAndHttpContent;
import org.jclouds.s3.functions.ParseObjectMetadataFromHeaders;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.s3.predicates.validators.BucketNameValidator;
import org.jclouds.s3.xml.AccessControlListHandler;
import org.jclouds.s3.xml.BucketLoggingHandler;
import org.jclouds.s3.xml.CopyObjectHandler;
import org.jclouds.s3.xml.ListAllMyBucketsHandler;
import org.jclouds.s3.xml.ListBucketHandler;
import org.jclouds.s3.xml.LocationConstraintHandler;
import org.jclouds.s3.xml.PayerHandler;

@Deprecated
@RequestFilters(value={RequestAuthorizeSignature.class})
@BlobScope(value=BlobScopes.CONTAINER)
public interface S3AsyncClient
extends Closeable {
    public static final String VERSION = "2006-03-01";

    @Provides
    public S3Object newS3Object();

    @Named(value="GetObject")
    @GET
    @Path(value="/{key}")
    @Fallback(value=BlobStoreFallbacks.NullOnKeyNotFound.class)
    @ResponseParser(value=ParseObjectFromHeadersAndHttpContent.class)
    public ListenableFuture<S3Object> getObject(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, GetOptions ... var3);

    @Named(value="GetObject")
    @HEAD
    @Path(value="/{key}")
    @Fallback(value=BlobStoreFallbacks.NullOnKeyNotFound.class)
    @ResponseParser(value=ParseObjectMetadataFromHeaders.class)
    public ListenableFuture<ObjectMetadata> headObject(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @Named(value="GetObject")
    @HEAD
    @Path(value="/{key}")
    @Fallback(value=BlobStoreFallbacks.FalseOnKeyNotFound.class)
    public ListenableFuture<Boolean> objectExists(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @Named(value="DeleteObject")
    @DELETE
    @Path(value="/{key}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteObject(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @Named(value="PutObject")
    @PUT
    @Path(value="/{key}")
    @Headers(keys={"Expect"}, values={"100-continue"})
    @ResponseParser(value=ParseETagHeader.class)
    public ListenableFuture<String> putObject(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") @ParamParser(value=ObjectKey.class) @BinderParam(value=BindS3ObjectMetadataToRequest.class) S3Object var2, PutObjectOptions ... var3);

    @Named(value="CreateBucket")
    @PUT
    @Path(value="/")
    @Endpoint(value=Bucket.class)
    @Fallback(value=FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists.class)
    public ListenableFuture<Boolean> putBucketInRegion(@BinderParam(value=BindRegionToXmlPayload.class) @Nullable String var1, @Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var2, PutBucketOptions ... var3);

    @Named(value="DeleteBucket")
    @DELETE
    @Path(value="/")
    @Fallback(value=S3Fallbacks.TrueOn404OrNotFoundFalseOnIllegalState.class)
    public ListenableFuture<Boolean> deleteBucketIfEmpty(@Bucket @EndpointParam(parser=DefaultEndpointThenInvalidateRegion.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="ListBucket")
    @GET
    @Path(value="/")
    @QueryParams(keys={"max-keys"}, values={"0"})
    @Fallback(value=BlobStoreFallbacks.FalseOnContainerNotFound.class)
    public ListenableFuture<Boolean> bucketExists(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="GetBucketLocation")
    @GET
    @QueryParams(keys={"location"})
    @Path(value="/")
    @Endpoint(value=Bucket.class)
    @XMLResponseParser(value=LocationConstraintHandler.class)
    public ListenableFuture<String> getBucketLocation(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="GetBucketRequestPayment")
    @GET
    @QueryParams(keys={"requestPayment"})
    @Path(value="/")
    @XMLResponseParser(value=PayerHandler.class)
    public ListenableFuture<Payer> getBucketPayer(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="PutBucketRequestPayment")
    @PUT
    @QueryParams(keys={"requestPayment"})
    @Path(value="/")
    public ListenableFuture<Void> setBucketPayer(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindPayerToXmlPayload.class) Payer var2);

    @Named(value="ListBucket")
    @GET
    @Path(value="/")
    @XMLResponseParser(value=ListBucketHandler.class)
    public ListenableFuture<ListBucketResponse> listBucket(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, ListBucketOptions ... var2);

    @Named(value="ListAllMyBuckets")
    @GET
    @XMLResponseParser(value=ListAllMyBucketsHandler.class)
    @Path(value="/")
    @VirtualHost
    public ListenableFuture<? extends Set<BucketMetadata>> listOwnedBuckets();

    @Named(value="PutObject")
    @PUT
    @Path(value="/{destinationObject}")
    @Headers(keys={"x-amz-copy-source"}, values={"/{sourceBucket}/{sourceObject}"})
    @XMLResponseParser(value=CopyObjectHandler.class)
    public ListenableFuture<ObjectMetadata> copyObject(@PathParam(value="sourceBucket") String var1, @PathParam(value="sourceObject") String var2, @Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var3, @PathParam(value="destinationObject") String var4, CopyObjectOptions ... var5);

    @Named(value="GetBucketAcl")
    @GET
    @QueryParams(keys={"acl"})
    @XMLResponseParser(value=AccessControlListHandler.class)
    @Fallback(value=BlobStoreFallbacks.ThrowContainerNotFoundOn404.class)
    @Path(value="/")
    public ListenableFuture<AccessControlList> getBucketACL(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="PutBucketAcl")
    @PUT
    @Path(value="/")
    @QueryParams(keys={"acl"})
    public ListenableFuture<Boolean> putBucketACL(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindACLToXMLPayload.class) AccessControlList var2);

    @Named(value="GetObjectAcl")
    @GET
    @QueryParams(keys={"acl"})
    @Path(value="/{key}")
    @XMLResponseParser(value=AccessControlListHandler.class)
    @Fallback(value=BlobStoreFallbacks.ThrowKeyNotFoundOn404.class)
    public ListenableFuture<AccessControlList> getObjectACL(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @Named(value="PutObjectAcl")
    @PUT
    @QueryParams(keys={"acl"})
    @Path(value="/{key}")
    public ListenableFuture<Boolean> putObjectACL(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @BinderParam(value=BindACLToXMLPayload.class) AccessControlList var3);

    @Named(value="GetBucketLogging")
    @GET
    @QueryParams(keys={"logging"})
    @XMLResponseParser(value=BucketLoggingHandler.class)
    @Fallback(value=BlobStoreFallbacks.ThrowContainerNotFoundOn404.class)
    @Path(value="/")
    public ListenableFuture<BucketLogging> getBucketLogging(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="PutBucketLogging")
    @PUT
    @Path(value="/")
    @QueryParams(keys={"logging"})
    public ListenableFuture<Void> enableBucketLogging(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindBucketLoggingToXmlPayload.class) BucketLogging var2);

    @Named(value="PutBucketLogging")
    @PUT
    @Path(value="/")
    @QueryParams(keys={"logging"})
    @Produces(value={"text/xml"})
    public ListenableFuture<Void> disableBucketLogging(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindNoBucketLoggingToXmlPayload.class) @ParamValidators(value={BucketNameValidator.class}) String var1);
}

