/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.features;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.net.URI;
import org.jclouds.sqs.SQSApi;
import org.jclouds.sqs.features.MessageApi;
import org.jclouds.sqs.internal.BaseSQSApiLiveTest;
import org.jclouds.sqs.options.ReceiveMessageOptions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="MessageApiLiveTest")
public class MessageApiLiveTest
extends BaseSQSApiLiveTest {
    String message = "hardyharhar";
    HashCode md5 = Hashing.md5().hashString((CharSequence)this.message, Charsets.UTF_8);
    String receiptHandle;

    public MessageApiLiveTest() {
        this.prefix = this.prefix + "-message";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.recreateQueueInRegion(this.prefix, null);
    }

    public void testSendMessage() {
        for (URI queue : this.queues) {
            Assert.assertEquals((Object)this.api(queue).send(this.message).getMD5(), (Object)this.md5);
        }
    }

    @Test(dependsOnMethods={"testSendMessage"})
    public void testReceiveMessageWithoutHidingMessage() {
        for (URI queue : this.queues) {
            Assert.assertEquals((Object)this.api(queue).receive(ReceiveMessageOptions.Builder.attribute((String)"All").visibilityTimeout(Integer.valueOf(0))).getMD5(), (Object)this.md5);
        }
    }

    @Test(dependsOnMethods={"testReceiveMessageWithoutHidingMessage"})
    public void testChangeMessageVisibility() {
        for (URI queue : this.queues) {
            MessageApi messageApi = this.api(queue);
            this.receiptHandle = messageApi.receive(ReceiveMessageOptions.Builder.attribute((String)"None").visibilityTimeout(Integer.valueOf(5))).getReceiptHandle();
            Assert.assertNull((Object)messageApi.receive());
            messageApi.changeVisibility(this.receiptHandle, 0);
            Assert.assertEquals((Object)messageApi.receive(ReceiveMessageOptions.Builder.attribute((String)"All").visibilityTimeout(Integer.valueOf(0))).getMD5(), (Object)this.md5);
        }
    }

    @Test(dependsOnMethods={"testChangeMessageVisibility"})
    public void testDeleteMessage() throws InterruptedException {
        for (URI queue : this.queues) {
            this.api(queue).delete(this.receiptHandle);
            this.assertNoMessages(queue);
        }
    }

    private MessageApi api(URI queue) {
        return ((SQSApi)this.api).getMessageApiForQueue(queue);
    }
}

