/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.internal;

import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.sqs.SQSApi;
import org.jclouds.sqs.domain.Message;
import org.jclouds.sqs.features.QueueApi;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BaseSQSApiLiveTest
extends BaseApiLiveTest<SQSApi> {
    protected String prefix = System.getProperty("user.name") + "-sqs";
    protected Set<URI> queues = Sets.newHashSet();
    private static final int INCONSISTENCY_WINDOW = 10000;

    public BaseSQSApiLiveTest() {
        this.provider = "sqs";
    }

    protected String getOwner(URI queue) {
        return (String)Iterables.get((Iterable)Splitter.on((char)'/').split((CharSequence)queue.getPath()), (int)1);
    }

    protected String recreateQueueInRegion(String queueName, String region) {
        QueueApi queueApi = ((SQSApi)this.api).getQueueApiForRegion(region);
        URI result = queueApi.get(queueName);
        if (result != null) {
            queueApi.delete(result);
        }
        URI queue = queueApi.create(queueName);
        this.assertQueueInList(region, queue);
        this.queues.add(queue);
        return queueName;
    }

    protected String assertPolicyPresent(final URI queue) {
        final AtomicReference policy = Atomics.newReference();
        BaseSQSApiLiveTest.assertEventually(new Runnable(){

            @Override
            public void run() {
                String policyForAuthorizationByAccount = ((SQSApi)BaseSQSApiLiveTest.this.api).getQueueApi().getAttribute(queue, "Policy");
                Assert.assertNotNull((Object)policyForAuthorizationByAccount);
                policy.set(policyForAuthorizationByAccount);
            }
        });
        return (String)policy.get();
    }

    protected void assertNoPermissions(final URI queue) {
        BaseSQSApiLiveTest.assertEventually(new Runnable(){

            @Override
            public void run() {
                String policy = ((SQSApi)BaseSQSApiLiveTest.this.api).getQueueApi().getAttribute(queue, "Policy");
                Assert.assertTrue((policy == null || policy.indexOf("\"Statement\":[]") != -1 ? 1 : 0) != 0, (String)policy);
            }
        });
    }

    protected void assertNoMessages(final URI queue) {
        BaseSQSApiLiveTest.assertEventually(new Runnable(){

            @Override
            public void run() {
                Message message = ((SQSApi)BaseSQSApiLiveTest.this.api).getMessageApiForQueue(queue).receive();
                Assert.assertNull((Object)message, (String)("message: " + message + " left in queue " + queue));
            }
        });
    }

    protected void assertQueueInList(final String region, URI queue) {
        final URI finalQ = queue;
        BaseSQSApiLiveTest.assertEventually(new Runnable(){

            @Override
            public void run() {
                FluentIterable result = ((SQSApi)BaseSQSApiLiveTest.this.api).getQueueApiForRegion(region).list();
                Assert.assertNotNull((Object)result);
                assert (result.size() >= 1) : result;
                Assert.assertTrue((boolean)result.contains((Object)finalQ), (String)(finalQ + " not in " + result));
            }
        });
    }

    protected static void assertEventually(Runnable assertion) {
        long start = System.currentTimeMillis();
        AssertionError error = null;
        for (int i = 0; i < 30; ++i) {
            try {
                assertion.run();
                if (i > 0) {
                    System.err.printf("%d attempts and %dms asserting %s%n", i + 1, System.currentTimeMillis() - start, assertion.getClass().getSimpleName());
                }
                return;
            }
            catch (AssertionError e) {
                error = e;
                Uninterruptibles.sleepUninterruptibly((long)333L, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    @AfterClass(groups={"live"})
    protected void tearDown() {
        for (URI queue : this.queues) {
            ((SQSApi)this.api).getQueueApi().delete(queue);
        }
        super.tearDown();
    }
}

