/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.handlers.AWSServerErrorRetryHandler;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSServerErrorRetryHandlerTest")
public class AWSServerErrorRetryHandlerTest {
    @Test
    public void test500DoesNotRetry() {
        AWSUtils utils = (AWSUtils)EasyMock.createMock(AWSUtils.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        EasyMock.replay((Object[])new Object[]{utils, command});
        AWSServerErrorRetryHandler retry = new AWSServerErrorRetryHandler(utils, (Set)ImmutableSet.of());
        Assert.assertFalse((boolean)retry.shouldRetryRequest(command, HttpResponse.builder().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).build()));
        EasyMock.verify((Object[])new Object[]{utils, command});
    }

    @DataProvider(name="codes")
    public Object[][] createData() {
        return new Object[][]{{"RequestLimitExceeded"}};
    }

    @Test(dataProvider="codes")
    public void test503DoesBackoffAndRetryForCode(String code) {
        AWSUtils utils = (AWSUtils)EasyMock.createMock(AWSUtils.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest putBucket = HttpRequest.builder().method("PUT").endpoint("https://adriancole-blobstore113.s3.amazonaws.com/").build();
        HttpResponse limitExceeded = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.SERVICE_UNAVAILABLE.getStatusCode()).payload((Payload)Payloads.newStringPayload((String)String.format("<Error><Code>%s</Code></Error>", code)))).build();
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)putBucket);
        final AtomicInteger counter = new AtomicInteger();
        EasyMock.expect((Object)command.incrementFailureCount()).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return counter.incrementAndGet();
            }
        }).anyTimes();
        EasyMock.expect((Object)command.isReplayable()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)command.getFailureCount()).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return counter.get();
            }
        }).anyTimes();
        AWSError error = new AWSError();
        error.setCode(code);
        EasyMock.expect((Object)utils.parseAWSErrorFromContent(putBucket, limitExceeded)).andReturn((Object)error);
        EasyMock.replay((Object[])new Object[]{utils, command});
        AWSServerErrorRetryHandler retry = new AWSServerErrorRetryHandler(utils, (Set)ImmutableSet.of((Object)"RequestLimitExceeded"));
        assert (retry.shouldRetryRequest(command, limitExceeded));
        EasyMock.verify((Object[])new Object[]{utils, command});
    }
}

