/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.aws.handlers.ParseAWSErrorFromXmlContent;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseAWSErrorFromXmlContentTest {
    @Test
    public void test400WithNotFoundSetsResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Error><Code>Monster.NotFound</Code></Error>", ResourceNotFoundException.class);
    }

    @Test
    public void test400WithCloudBridgeNotFoundSetsResourceNotFoundException() {
        this.assertCodeMakes("POST", URI.create("https://api.greenqloud.com/"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Error><Code>Client.InvalidInstanceID.NotFound</Code></Error>", ResourceNotFoundException.class);
    }

    @Test
    public void test400WithInvalidIdIllegalArgumentException() {
        this.assertCodeMakes("POST", URI.create("https://ec2.us-east-1.amazonaws.com"), Response.Status.BAD_REQUEST.getStatusCode(), "HTTP/1.1 400", "", "Invalid id: \"asdaasdsa\" (expecting \"ami-...\")", IllegalArgumentException.class);
    }

    @Test
    public void test400WithLoadBalancerNotFoundSetsResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Error><Code>LoadBalancerNotFound</Code></Error>", ResourceNotFoundException.class);
    }

    @Test
    public void test400WithSecurityGroupNotFoundForProjectSetsResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Error><Code>SecurityGroupNotFoundForProject</Code></Error>", ResourceNotFoundException.class);
    }

    @Test
    public void test400WithUnsupportedCodeMakesUnsupportedOperationException() {
        this.assertCodeMakes("POST", URI.create("https://ec2.us-west-1.amazonaws.com/"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Error><Code>UnsupportedOperation</Code></Error>", UnsupportedOperationException.class);
    }

    @Test
    public void test400WithAddressLimitExceededCodeMakesInsufficientResourcesException() {
        this.assertCodeMakes("POST", URI.create("https://ec2.us-east-1.amazonaws.com/"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Response><Errors><Error><Code>AddressLimitExceeded</Code><Message>Too many addresses allocated</Message></Error></Errors><RequestID>c14f531a-cc35-4b48-8149-2655c7e6dc76</RequestID></Response>", InsufficientResourcesException.class);
    }

    @Test
    public void test400WithTooManyBucketsCodeMakesInsufficientResourcesException() {
        this.assertCodeMakes("POST", URI.create("https://ec2.us-east-1.amazonaws.com/"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Response><Errors><Error><Code>TooManyBuckets</Code><Message>You have attempted to create more buckets than allowed</Message></Error></Errors><RequestID>c14f531a-cc35-4b48-8149-2655c7e6dc76</RequestID></Response>", InsufficientResourcesException.class);
    }

    @Test
    public void test400WithInUseCodeSetsIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Error><Code>InvalidPlacementGroup.InUse</Code></Error>", IllegalStateException.class);
    }

    @Test
    public void test400WithUnknownSetsResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Error><Code>InvalidPlacementGroup.Unknown</Code></Error>", ResourceNotFoundException.class);
    }

    @Test
    public void test400WithIncorrectStateSetsIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Error><Code>IncorrectState</Code></Error>", IllegalStateException.class);
    }

    @Test
    public void test400WithInUseSetsIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), "", "text/plain", "The placement group 'jclouds#adriancoleec2cccluster#us-east-1' is in use and may not be deleted.", IllegalStateException.class);
    }

    @Test
    public void test409SetsIllegalStateException() {
        this.assertCodeMakes("PUT", URI.create("https://adriancole-blobstore011.s3.amazonaws.com/"), Response.Status.CONFLICT.getStatusCode(), "", "<Error><Code>OperationAborted</Code><Message>A conflicting conditional operation is currently in progress against this resource. Please try again.</Message><RequestId>F716E81C3D814E59</RequestId><HostId>SDprHxWzG/YXzanVnV7VTz/wP+6fRt1dS+q00kH1rz248YOOSddkFiTXF04XtqNO</HostId></Error>", IllegalStateException.class);
    }

    @Test
    public void test400WithInvalidGroupDuplicateIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), Response.Status.BAD_REQUEST.getReasonPhrase(), "application/unknown", "<Error><Code>InvalidGroup.Duplicate</Code></Error>", IllegalStateException.class);
    }

    @Test
    public void test400WithInvalidKeyPairGroupDuplicateIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), Response.Status.BAD_REQUEST.getReasonPhrase(), "application/unknown", "<Error><Code>InvalidKeyPair.Duplicate</Code></Error>", IllegalStateException.class);
    }

    @Test
    public void test400WithTextPlainIllegalArgumentException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), Response.Status.BAD_REQUEST.getReasonPhrase(), "text/plain", "Failure: 400 Bad Request\nFailed to bind the following fields\nMonitoring.Enabled = true\n\n\n", IllegalArgumentException.class);
    }

    @Test
    public void test400WithGroupAlreadyExistsEucalyptusIllegalStateException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<?xml version=\"1.0\"?><Response><Errors><Error><Code>Groups</Code><Message>\nError adding network group: group named jclouds#eucrun#Eucalyptus already exists\nError adding network group: group named jclouds#eucrun#Eucalyptus already exists</Message></Error></Errors><RequestID>e0133975-3bc5-456d-9753-1d61b27e07e9</RequestID></Response>", IllegalStateException.class);
    }

    @Test
    public void test400WithAuthFailureSetsAuthorizationException() {
        this.assertCodeMakes("GET", URI.create("https://amazonaws.com/foo"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Error><Code>AuthFailure</Code></Error>", AuthorizationException.class);
    }

    @Test
    public void test400WithCloudBridgeAuthFailureSetsAuthorizationException() {
        this.assertCodeMakes("POST", URI.create("https://api.greenqloud.com/"), Response.Status.BAD_REQUEST.getStatusCode(), "", "<Error><Code>Client.AuthFailure</Code></Error>", AuthorizationException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String content, Class<? extends Exception> expected) {
        this.assertCodeMakes(method, uri, statusCode, message, "text/xml", content, expected);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        ParseAWSErrorFromXmlContent function = (ParseAWSErrorFromXmlContent)Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind(RequestSigner.class).toInstance(EasyMock.createMock(RequestSigner.class));
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.aws.header.tag")).to("amz");
            }
        }}).getInstance(ParseAWSErrorFromXmlContent.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method(method).endpoint(uri).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(ParseAWSErrorFromXmlContentTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

