/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.util;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.filters.FormSignerTest;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(singleThreaded=true, groups={"unit"}, testName="AWSUtilsTest")
public class AWSUtilsTest {
    AWSUtils utils = null;
    private HttpCommand command;

    @BeforeTest
    protected void setUpInjector() throws IOException {
        this.utils = (AWSUtils)FormSignerTest.injector(new Credentials("identity", "credential")).getInstance(AWSUtils.class);
        this.command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        EasyMock.expect((Object)this.command.getCurrentRequest()).andReturn(EasyMock.createMock(HttpRequest.class)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.command});
    }

    @AfterTest
    protected void tearDownInjector() {
        this.utils = null;
    }

    HttpResponse response(InputStream content) {
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).message("boa").payload(content)).addHeader("x-amz-request-id", new String[]{"requestid"})).addHeader("x-amz-id-2", new String[]{"requesttoken"})).build();
        response.getPayload().getContentMetadata().setContentType("text/xml");
        return response;
    }

    @Test
    public void testNoExceptionWhenNoPayload() {
        HttpResponse response = HttpResponse.builder().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).build();
        Assert.assertNull((Object)this.utils.parseAWSErrorFromContent(this.command.getCurrentRequest(), response));
    }

    @Test
    public void testNoExceptionParsingTextPlain() {
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).payload("foo bar")).build();
        response.getPayload().getContentMetadata().setContentType("text/plain");
        Assert.assertNull((Object)this.utils.parseAWSErrorFromContent(this.command.getCurrentRequest(), response));
    }

    @Test
    public void testParseAWSErrorFromContentHttpCommandHttpResponseInputStream() {
        AWSError error = this.utils.parseAWSErrorFromContent(this.command.getCurrentRequest(), this.response(this.getClass().getResourceAsStream("/error.xml")));
        Assert.assertEquals((String)error.getCode(), (String)"NoSuchKey");
        Assert.assertEquals((String)error.getMessage(), (String)"The resource you requested does not exist");
        Assert.assertEquals((String)error.getRequestToken(), (String)"requesttoken");
        Assert.assertEquals((String)error.getRequestId(), (String)"4442587FB7D0A2F9");
        Assert.assertEquals((String)((String)error.getDetails().get("Resource")), (String)"/mybucket/myfoto.jpg");
    }

    @Test
    public void testValidateBucketName() {
    }
}

