/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.xml;

import java.io.InputStream;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.aws.xml.SessionCredentialsHandler;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SessionCredentialsHandlerTest")
public class SessionCredentialsHandlerTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/credentials.xml");
        SessionCredentials expected = this.expected();
        SessionCredentialsHandler handler = (SessionCredentialsHandler)this.injector.getInstance(SessionCredentialsHandler.class);
        SessionCredentials result = (SessionCredentials)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
        Assert.assertEquals((String)result.getAccessKeyId(), (String)expected.getAccessKeyId());
        Assert.assertEquals((String)result.getSecretAccessKey(), (String)expected.getSecretAccessKey());
        Assert.assertEquals((String)result.getSessionToken(), (String)expected.getSessionToken());
        Assert.assertEquals((Object)result.getExpiration(), (Object)expected.getExpiration());
    }

    public SessionCredentials expected() {
        return SessionCredentials.builder().accessKeyId("AKIAIOSFODNN7EXAMPLE").secretAccessKey("wJalrXUtnFEMI/K7MDENG/bPxRfiCYzEXAMPLEKEY").sessionToken("AQoEXAMPLEH4aoAH0gNCAPyJxz4BlCFFxWNE1OPTgk5TthT").expiration(new SimpleDateFormatDateService().iso8601DateParse("2011-07-11T19:55:29.611Z")).build();
    }
}

