/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.sts.STSApi;
import org.jclouds.sts.internal.BaseSTSApiExpectTest;
import org.jclouds.sts.options.AssumeRoleOptions;
import org.jclouds.sts.options.FederatedUserOptions;
import org.jclouds.sts.options.SessionCredentialsOptions;
import org.jclouds.sts.parse.AssumeRoleResponseTest;
import org.jclouds.sts.parse.GetFederationTokenResponseTest;
import org.jclouds.sts.parse.GetSessionTokenResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="STSApiExpectTest")
public class STSApiExpectTest
extends BaseSTSApiExpectTest {
    HttpRequest createTemporaryCredentials = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sts.amazonaws.com/").addHeader("Host", new String[]{"sts.amazonaws.com"})).addFormParam("Action", new String[]{"GetSessionToken"}).addFormParam("Signature", new String[]{"ntC%2BPKAcmYTJ5Py5tjICG4KX5y00Pl2L0XJrLbSgLEs%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpResponse createTemporaryCredentialsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/session_token.xml", "text/xml"))).build();
    HttpRequest createTemporaryCredentialsWithOptions = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sts.amazonaws.com/").addHeader("Host", new String[]{"sts.amazonaws.com"})).addFormParam("Action", new String[]{"GetSessionToken"}).addFormParam("DurationSeconds", new String[]{"900"}).addFormParam("SerialNumber", new String[]{"YourMFADeviceSerialNumber"}).addFormParam("Signature", new String[]{"e4HEkfKrw7EuLEQhe4/lK1l7ZmaynO3snsIMU/cdarI%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("TokenCode", new String[]{"1234"}).addFormParam("Version", new String[]{"2011-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest assumeRole = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sts.amazonaws.com/").addHeader("Host", new String[]{"sts.amazonaws.com"})).addFormParam("Action", new String[]{"AssumeRole"}).addFormParam("RoleArn", new String[]{"arn:aws:iam::123456789012:role/demo"}).addFormParam("RoleSessionName", new String[]{"Bob"}).addFormParam("Signature", new String[]{"0G1%2B6GX4cSU9Tjf2SyQ9oW5ivFri4BQPif/24FoRiWY%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpResponse assumeRoleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/assume_role.xml", "text/xml"))).build();
    String policy = "{\"Statement\":[{\"Sid\":\"Stmt1\",\"Effect\":\"Allow\",\"Action\":\"s3:*\",\"Resource\":\"*\"}]}";
    HttpRequest assumeRoleWithOptions = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sts.amazonaws.com/").addHeader("Host", new String[]{"sts.amazonaws.com"})).addFormParam("Action", new String[]{"AssumeRole"}).addFormParam("DurationSeconds", new String[]{"900"}).addFormParam("ExternalId", new String[]{"123ABC"}).addFormParam("Policy", new String[]{this.policy}).addFormParam("RoleArn", new String[]{"arn:aws:iam::123456789012:role/demo"}).addFormParam("RoleSessionName", new String[]{"Bob"}).addFormParam("Signature", new String[]{"9qffV6zHRbTX8E9IYbEFeQPWrHEdSbwUfjJpg1SMaBo%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest createFederatedUser = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sts.amazonaws.com/").addHeader("Host", new String[]{"sts.amazonaws.com"})).addFormParam("Action", new String[]{"GetFederationToken"}).addFormParam("Name", new String[]{"Bob"}).addFormParam("Signature", new String[]{"Z7AtGK4X9IAx/zMtLD7baNiyltNl%2BF%2BSHqjIGUidzOc%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpResponse createFederatedUserResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/federation_token.xml", "text/xml"))).build();
    HttpRequest createFederatedUserWithOptions = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sts.amazonaws.com/").addHeader("Host", new String[]{"sts.amazonaws.com"})).addFormParam("Action", new String[]{"GetFederationToken"}).addFormParam("DurationSeconds", new String[]{"900"}).addFormParam("Name", new String[]{"Bob"}).addFormParam("Policy", new String[]{this.policy}).addFormParam("Signature", new String[]{"%2BWGvCNtmb1UPmQHxXPMvcK6vH/TJ9r/wCuxdz03n/2w%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testCreateTemporaryCredentialsWhenResponseIs2xx() {
        STSApi apiWhenWithOptionsExist = (STSApi)this.requestSendsResponse(this.createTemporaryCredentials, this.createTemporaryCredentialsResponse);
        Assert.assertEquals((String)apiWhenWithOptionsExist.createTemporaryCredentials().toString(), (String)new GetSessionTokenResponseTest().expected().toString());
    }

    public void testCreateTemporaryCredentialsWithOptionsWhenResponseIs2xx() {
        STSApi apiWhenWithOptionsExist = (STSApi)this.requestSendsResponse(this.createTemporaryCredentialsWithOptions, this.createTemporaryCredentialsResponse);
        Assert.assertEquals((String)apiWhenWithOptionsExist.createTemporaryCredentials(SessionCredentialsOptions.Builder.serialNumber((String)"YourMFADeviceSerialNumber").tokenCode("1234").durationSeconds(TimeUnit.MINUTES.toSeconds(15L))).toString(), (String)new GetSessionTokenResponseTest().expected().toString());
    }

    public void testAssumeRoleWhenResponseIs2xx() {
        STSApi apiWhenWithOptionsExist = (STSApi)this.requestSendsResponse(this.assumeRole, this.assumeRoleResponse);
        Assert.assertEquals((String)apiWhenWithOptionsExist.assumeRole("arn:aws:iam::123456789012:role/demo", "Bob").toString(), (String)new AssumeRoleResponseTest().expected().toString());
    }

    public void testAssumeRoleWithOptionsWhenResponseIs2xx() {
        STSApi apiWhenWithOptionsExist = (STSApi)this.requestSendsResponse(this.assumeRoleWithOptions, this.assumeRoleResponse);
        Assert.assertEquals((String)apiWhenWithOptionsExist.assumeRole("arn:aws:iam::123456789012:role/demo", "Bob", AssumeRoleOptions.Builder.externalId((String)"123ABC").policy(this.policy).durationSeconds(TimeUnit.MINUTES.toSeconds(15L))).toString(), (String)new AssumeRoleResponseTest().expected().toString());
    }

    public void testCreateFederatedUserWhenResponseIs2xx() {
        STSApi apiWhenWithOptionsExist = (STSApi)this.requestSendsResponse(this.createFederatedUser, this.createFederatedUserResponse);
        Assert.assertEquals((String)apiWhenWithOptionsExist.createFederatedUser("Bob").toString(), (String)new GetFederationTokenResponseTest().expected().toString());
    }

    public void testCreateFederatedUserWithOptionsWhenResponseIs2xx() {
        STSApi apiWhenWithOptionsExist = (STSApi)this.requestSendsResponse(this.createFederatedUserWithOptions, this.createFederatedUserResponse);
        Assert.assertEquals((String)apiWhenWithOptionsExist.createFederatedUser("Bob", FederatedUserOptions.Builder.policy((String)this.policy).durationSeconds(TimeUnit.MINUTES.toSeconds(15L))).toString(), (String)new GetFederationTokenResponseTest().expected().toString());
    }
}

