/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.functions.URIFromAuthenticationResponseForService;
import org.jclouds.openstack.internal.TestOpenStackAuthenticationModule;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.openstack.swift.SwiftApiMetadata;
import org.jclouds.openstack.swift.SwiftAsyncClient;
import org.jclouds.openstack.swift.TemporaryUrlKey;
import org.jclouds.openstack.swift.blobstore.SwiftBlobSigner;
import org.jclouds.openstack.swift.blobstore.config.SwiftBlobStoreContextModule;
import org.jclouds.openstack.swift.blobstore.config.TemporaryUrlExtensionModule;
import org.jclouds.openstack.swift.config.SwiftRestClientModule;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CommonSwiftClientTest")
public abstract class CommonSwiftClientTest
extends BaseAsyncClientTest<SwiftAsyncClient> {
    public static final long UNIX_EPOCH_TIMESTAMP = 123456789L;
    public static final String TEMPORARY_URL_KEY = "get-or-set-X-Account-Meta-Temp-Url-Key";
    protected String provider = "swift";

    protected void checkFilters(HttpRequest request) {
    }

    protected ApiMetadata createApiMetadata() {
        return ((SwiftApiMetadata.Builder)new SwiftApiMetadata().toBuilder().defaultModules((Set)ImmutableSet.builder().add(StorageEndpointModule.class).add(SwiftRestClientModule.class).add(SwiftBlobStoreContextModule.class).add(StaticTimeAndTemporaryUrlKeyModule.class).build())).build();
    }

    protected Properties setupProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.regions", "US");
        properties.setProperty("jclouds.endpoint", "https://auth");
        properties.setProperty("jclouds.api-version", "1");
        return properties;
    }

    public static class StaticTimeAndTemporaryUrlKeyModule
    extends TemporaryUrlExtensionModule<SwiftAsyncClient> {
        protected Long unixEpochTimestampProvider() {
            return 123456789L;
        }

        protected void configure() {
            this.bindTemporaryUrlKeyApi();
            this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).annotatedWith(TemporaryUrlKey.class).toInstance((Object)Suppliers.ofInstance((Object)CommonSwiftClientTest.TEMPORARY_URL_KEY));
        }

        protected void bindRequestSigner() {
            this.bind(BlobRequestSigner.class).to((TypeLiteral)new TypeLiteral<SwiftBlobSigner<SwiftAsyncClient>>(){});
        }
    }

    public static class StorageEndpointModule
    extends TestOpenStackAuthenticationModule {
        @Provides
        @Singleton
        @Storage
        protected Supplier<URI> provideStorageUrl(URIFromAuthenticationResponseForService.Factory factory) {
            return factory.create("X-Storage-Url");
        }
    }
}

