/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.integration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.integration.internal.BaseContainerIntegrationTest;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.options.CreateContainerOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class SwiftContainerIntegrationLiveTest
extends BaseContainerIntegrationTest {
    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        this.setIfTestSystemPropertyPresent(props, "jclouds.keystone.credential-type");
        return props;
    }

    public SwiftContainerIntegrationLiveTest() {
        this.provider = System.getProperty("test.swift.provider", "swift");
    }

    @Test(groups={"live"})
    public void testSetGetContainerMetadata() throws InterruptedException {
        CommonSwiftClient swift = (CommonSwiftClient)((BlobStoreContext)this.view).utils().injector().getInstance(CommonSwiftClient.class);
        String containerName = this.getContainerName();
        ImmutableMap metadata = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
        Assert.assertTrue((boolean)swift.setContainerMetadata(containerName, (Map)metadata));
        ContainerMetadata containerMetadata = swift.getContainerMetadata(containerName);
        Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("key1")), (String)"value1");
        Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("key2")), (String)"value2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"live"})
    public void testCreateDeleteContainerMetadata() throws InterruptedException {
        CommonSwiftClient swift = (CommonSwiftClient)((BlobStoreContext)this.view).utils().injector().getInstance(CommonSwiftClient.class);
        CreateContainerOptions options = CreateContainerOptions.Builder.withPublicAccess().withMetadata((Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2", (Object)"key3", (Object)"value3"));
        String containerName = this.getScratchContainerName();
        Assert.assertTrue((boolean)swift.createContainer(containerName, new CreateContainerOptions[]{options}));
        try {
            ContainerMetadata containerMetadata = swift.getContainerMetadata(containerName);
            Assert.assertEquals((int)containerMetadata.getMetadata().size(), (int)3);
            Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("key1")), (String)"value1");
            Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("key2")), (String)"value2");
            Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("key3")), (String)"value3");
            Assert.assertTrue((boolean)swift.deleteContainerMetadata(containerName, (Iterable)ImmutableList.of((Object)"key2", (Object)"key3")));
            containerMetadata = swift.getContainerMetadata(containerName);
            Assert.assertEquals((int)containerMetadata.getMetadata().size(), (int)1);
            Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("key1")), (String)"value1");
        }
        finally {
            this.returnContainer(containerName);
        }
    }
}

