/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.functions.ParseContainerMetadataFromHeaders;
import org.jclouds.openstack.swift.internal.BasePayloadTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseContainerMetadataFromHeadersTest
extends BasePayloadTest {
    public void testParseContainerMetadataHeaders() {
        ParseContainerMetadataFromHeaders parser = (ParseContainerMetadataFromHeaders)this.i.getInstance(ParseContainerMetadataFromHeaders.class);
        parser.setContext((HttpRequest)this.requestForArgs((List<Object>)ImmutableList.of((Object)"container", (Object)"key")));
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(204).message("No Content").payload("")).addHeader("X-Container-Bytes-Used", new String[]{"42"})).addHeader("X-Container-Object-Count", new String[]{"1"})).addHeader("X-Container-Meta-label1", new String[]{"test1"})).addHeader("X-Container-Meta-label2", new String[]{"test2"})).build();
        response.getPayload().getContentMetadata().setContentType("text/plain");
        ContainerMetadata containerMetadata = parser.apply(response);
        Assert.assertEquals((long)containerMetadata.getBytes(), (long)42L);
        Assert.assertEquals((long)containerMetadata.getCount(), (long)1L);
        Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("label1")), (String)"test1");
        Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("label2")), (String)"test2");
    }
}

