/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.blobstore.strategy.internal.MultipartUploadSlicingAlgorithm;
import org.jclouds.openstack.swift.blobstore.strategy.internal.MultipartUploadStrategy;

public class SequentialMultipartUploadStrategy
implements MultipartUploadStrategy {
    private static final String PART_SEPARATOR = "/";
    @Resource
    @Named(value="jclouds.blobstore")
    private Logger logger = Logger.NULL;
    private final CommonSwiftClient client;
    private final Provider<BlobBuilder> blobBuilders;
    private final BlobToObject blob2Object;
    private final MultipartUploadSlicingAlgorithm algorithm;
    private final PayloadSlicer slicer;

    @Inject
    public SequentialMultipartUploadStrategy(CommonSwiftClient client, Provider<BlobBuilder> blobBuilders, BlobToObject blob2Object, MultipartUploadSlicingAlgorithm algorithm, PayloadSlicer slicer) {
        this.client = (CommonSwiftClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.blobBuilders = (Provider)Preconditions.checkNotNull(blobBuilders, (Object)"blobBuilders");
        this.blob2Object = (BlobToObject)Preconditions.checkNotNull((Object)blob2Object, (Object)"blob2Object");
        this.algorithm = (MultipartUploadSlicingAlgorithm)Preconditions.checkNotNull((Object)algorithm, (Object)"algorithm");
        this.slicer = (PayloadSlicer)Preconditions.checkNotNull((Object)slicer, (Object)"slicer");
    }

    @Override
    public String execute(String container, Blob blob) {
        String key = blob.getMetadata().getName();
        Payload payload = blob.getPayload();
        Long length = payload.getContentMetadata().getContentLength();
        Preconditions.checkNotNull((Object)length, (Object)"please invoke payload.getContentMetadata().setContentLength(length) prior to multipart upload");
        long chunkSize = this.algorithm.calculateChunkSize(length);
        int partCount = this.algorithm.getParts();
        if (partCount > 0) {
            int part;
            while ((part = this.algorithm.getNextPart()) <= partCount) {
                Payload chunkedPart = this.slicer.slice(payload, this.algorithm.getNextChunkOffset(), chunkSize);
                Blob blobPart = ((BlobBuilder)this.blobBuilders.get()).name(key + PART_SEPARATOR + part).payload(chunkedPart).contentDisposition(key + PART_SEPARATOR + part).build();
                this.client.putObject(container, this.blob2Object.apply(blobPart));
            }
            long remaining = this.algorithm.getRemaining();
            if (remaining > 0L) {
                Payload chunkedPart = this.slicer.slice(payload, this.algorithm.getNextChunkOffset(), remaining);
                Blob blobPart = ((BlobBuilder)this.blobBuilders.get()).name(key + PART_SEPARATOR + part).payload(chunkedPart).contentDisposition(key + PART_SEPARATOR + part).build();
                this.client.putObject(container, this.blob2Object.apply(blobPart));
            }
            return this.client.putObjectManifest(container, key);
        }
        return this.client.putObject(container, this.blob2Object.apply(blob));
    }
}

