/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.cim.xml.ResourceAllocationSettingDataHandler;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.VCloudApiMetadata;
import org.jclouds.vcloud.compute.config.VCloudComputeServiceDependenciesModule;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.functions.HardwareForVApp;
import org.jclouds.vcloud.compute.functions.VAppToNodeMetadata;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.internal.VAppImpl;
import org.jclouds.vcloud.xml.VAppHandler;
import org.jclouds.vcloud.xml.ovf.VCloudResourceAllocationSettingDataHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class VAppToNodeMetadataTest {
    public Injector createInjectorWithLocation(final Location location) {
        return Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)new VCloudApiMetadata().getDefaultProperties());
                this.bind((TypeLiteral)new TypeLiteral<Function<ReferenceType, Location>>(){}).to((TypeLiteral)new TypeLiteral<FindLocationForResource>(){});
                this.bind((TypeLiteral)new TypeLiteral<Function<VApp, Hardware>>(){}).to((TypeLiteral)new TypeLiteral<HardwareForVApp>(){});
                this.bind(ResourceAllocationSettingDataHandler.class).to(VCloudResourceAllocationSettingDataHandler.class);
            }

            @Memoized
            @Singleton
            @Provides
            Supplier<Set<? extends Location>> supplyLocations() {
                return Suppliers.ofInstance((Object)ImmutableSet.of((Object)location));
            }

            @Singleton
            @Provides
            Map<String, Credentials> supplyCreds() {
                return Maps.newConcurrentMap();
            }

            @Singleton
            @Provides
            protected Map<Status, NodeMetadata.Status> provideVAppStatusToNodeStatus() {
                return VCloudComputeServiceDependenciesModule.toPortableNodeStatus;
            }
        }});
    }

    public void testWhenVDCIsLocation() {
        Location location = new LocationBuilder().id("https://1.1.1.1/api/v1.0/vdc/1").description("description").scope(LocationScope.PROVIDER).build();
        Injector injector = this.createInjectorWithLocation(location);
        InputStream is = this.getClass().getResourceAsStream("/vapp-pool.xml");
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VApp result = (VApp)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VAppHandler.class)).parse(is);
        VAppToNodeMetadata converter = (VAppToNodeMetadata)injector.getInstance(VAppToNodeMetadata.class);
        NodeMetadata node = converter.apply(result);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Map)node.getUserMetadata(), (Map)ImmutableMap.of());
        Assert.assertEquals((Set)node.getTags(), (Set)ImmutableSet.of());
        Assert.assertEquals((Object)node.getLocation(), (Object)location);
        Assert.assertEquals((Set)node.getPrivateAddresses(), (Set)ImmutableSet.of((Object)"172.16.7.230"));
        Assert.assertEquals((Set)node.getPublicAddresses(), (Set)ImmutableSet.of());
    }

    public void testWithMetadataParseException() {
        Location location = new LocationBuilder().id("https://1.1.1.1/api/v1.0/vdc/1").description("description").scope(LocationScope.PROVIDER).build();
        Injector injector = this.createInjectorWithLocation(location);
        InputStream is = this.getClass().getResourceAsStream("/vapp-pool.xml");
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VApp result = (VApp)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VAppHandler.class)).parse(is);
        VAppToNodeMetadata converter = (VAppToNodeMetadata)injector.getInstance(VAppToNodeMetadata.class);
        ImmutableMap metadata = ImmutableMap.of();
        ImmutableSet tags = ImmutableSet.of();
        String description = " user=user_ssoid_1\nuid=3b7bb605-bb30-4e62-a3de-9076b052dee7 label='foo-DEVELOPMENT' date=2013-01-22 17:39:28.252";
        result = new VAppImpl(result.getName(), result.getType(), result.getHref(), result.getStatus(), result.getVDC(), description, (Iterable)result.getTasks(), result.isOvfDescriptorUploaded(), (Iterable)result.getChildren(), result.getNetworkSection());
        NodeMetadata node = converter.apply(result);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Map)node.getUserMetadata(), (Map)metadata);
        Assert.assertEquals((Set)node.getTags(), (Set)tags);
    }

    public void testWithMetadataNoNewLines() {
        Location location = new LocationBuilder().id("https://1.1.1.1/api/v1.0/vdc/1").description("description").scope(LocationScope.PROVIDER).build();
        Injector injector = this.createInjectorWithLocation(location);
        InputStream is = this.getClass().getResourceAsStream("/vapp-pool.xml");
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VApp result = (VApp)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VAppHandler.class)).parse(is);
        VAppToNodeMetadata converter = (VAppToNodeMetadata)injector.getInstance(VAppToNodeMetadata.class);
        ImmutableMap metadata = ImmutableMap.of();
        ImmutableSet tags = ImmutableSet.of();
        String description = " user=user_ssoid_1 uid=3b7bb605-bb30-4e62-a3de-9076b052dee7 label='foo-DEVELOPMENT' date=2013-01-22 17:39:28.252";
        result = new VAppImpl(result.getName(), result.getType(), result.getHref(), result.getStatus(), result.getVDC(), description, (Iterable)result.getTasks(), result.isOvfDescriptorUploaded(), (Iterable)result.getChildren(), result.getNetworkSection());
        NodeMetadata node = converter.apply(result);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Map)node.getUserMetadata(), (Map)metadata);
        Assert.assertEquals((Set)node.getTags(), (Set)tags);
    }

    public void testWithEncodedMetadata() {
        Location location = new LocationBuilder().id("https://1.1.1.1/api/v1.0/vdc/1").description("description").scope(LocationScope.PROVIDER).build();
        Injector injector = this.createInjectorWithLocation(location);
        InputStream is = this.getClass().getResourceAsStream("/vapp-pool.xml");
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VApp result = (VApp)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VAppHandler.class)).parse(is);
        VAppToNodeMetadata converter = (VAppToNodeMetadata)injector.getInstance(VAppToNodeMetadata.class);
        ImmutableMap metadata = ImmutableMap.of((Object)"foo", (Object)"bar");
        ImmutableSet tags = ImmutableSet.of((Object)"tag1", (Object)"tag2");
        String description = Joiner.on((char)'\n').withKeyValueSeparator("=").join((Map)ImmutableMap.builder().putAll((Map)metadata).put((Object)"jclouds_tags", (Object)Joiner.on((char)',').join((Iterable)tags)).build());
        result = new VAppImpl(result.getName(), result.getType(), result.getHref(), result.getStatus(), result.getVDC(), description, (Iterable)result.getTasks(), result.isOvfDescriptorUploaded(), (Iterable)result.getChildren(), result.getNetworkSection());
        NodeMetadata node = converter.apply(result);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Map)node.getUserMetadata(), (Map)metadata);
        Assert.assertEquals((Set)node.getTags(), (Set)tags);
    }

    public void testGracefulWhenNoIPs() {
        Location location = new LocationBuilder().id("https://1.1.1.1/api/v1.0/vdc/1").description("description").scope(LocationScope.PROVIDER).build();
        Injector injector = this.createInjectorWithLocation(location);
        InputStream is = this.getClass().getResourceAsStream("/vapp-none.xml");
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VApp result = (VApp)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VAppHandler.class)).parse(is);
        VAppToNodeMetadata converter = (VAppToNodeMetadata)injector.getInstance(VAppToNodeMetadata.class);
        NodeMetadata node = converter.apply(result);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)node.getLocation(), (Object)location);
        Assert.assertEquals((Set)node.getPrivateAddresses(), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)node.getPublicAddresses(), (Set)ImmutableSet.of());
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testGracefulWhenVDCIsNotLocation() {
        Location location = new LocationBuilder().id("https://1.1.1.1/api/v1.0/vdc/11111").description("description").scope(LocationScope.PROVIDER).build();
        Injector injector = this.createInjectorWithLocation(location);
        InputStream is = this.getClass().getResourceAsStream("/vapp-pool.xml");
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VApp result = (VApp)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VAppHandler.class)).parse(is);
        VAppToNodeMetadata converter = (VAppToNodeMetadata)injector.getInstance(VAppToNodeMetadata.class);
        NodeMetadata node = converter.apply(result);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)node.getLocation(), (Object)location);
    }
}

