/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import org.jclouds.cim.xml.ResourceAllocationSettingDataHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.xml.GuestCustomizationSectionHandlerTest;
import org.jclouds.vcloud.xml.NetworkConnectionSectionHandlerTest;
import org.jclouds.vcloud.xml.VmHandler;
import org.jclouds.vcloud.xml.ovf.VCloudOperatingSystemSectionHandlerTest;
import org.jclouds.vcloud.xml.ovf.VCloudResourceAllocationSettingDataHandler;
import org.jclouds.vcloud.xml.ovf.VCloudVirtualHardwareSectionHandlerTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class VmHandlerTest {
    public void testVCloud1_0() {
        InputStream is = this.getClass().getResourceAsStream("/vm-rhel-off-static.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(){

            protected void configure() {
                super.configure();
                this.bind(ResourceAllocationSettingDataHandler.class).to(VCloudResourceAllocationSettingDataHandler.class);
            }
        }});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        Vm result = (Vm)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VmHandler.class)).parse(is);
        VmHandlerTest.checkVm(result);
    }

    static void checkVm(Vm result) {
        Assert.assertEquals((String)result.getName(), (String)"RHEL5");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vm-2087535248"));
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.vm+xml");
        Assert.assertEquals((Object)result.getStatus(), (Object)Status.OFF);
        Assert.assertEquals((Object)result.getParent(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vapp-607806320")));
        Assert.assertEquals((String)result.getDescription(), null);
        Assert.assertEquals((Collection)result.getTasks(), (Collection)ImmutableList.of());
        Assert.assertEquals((String)result.getVAppScopedLocalId(), (String)"10_rhel_template");
        VCloudVirtualHardwareSectionHandlerTest.checkHardware(result.getVirtualHardwareSection());
        VCloudOperatingSystemSectionHandlerTest.checkOs(result.getOperatingSystemSection());
        NetworkConnectionSectionHandlerTest.checkNetworkConnectionSection(result.getNetworkConnectionSection());
        GuestCustomizationSectionHandlerTest.checkGuestCustomization(result.getGuestCustomizationSection());
    }
}

