/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.regex.Pattern;
import org.jclouds.Fallback;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;

public final class TerremarkVCloudFallbacks {
    private TerremarkVCloudFallbacks() {
    }

    public static final class VoidOnDeleteDefaultIp
    implements Fallback<Void> {
        public static final Pattern MESSAGE_PATTERN = Pattern.compile(".*Cannot release this Public IP as it is default oubound IP.*");

        public ListenableFuture<Void> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Void createOrPropagate(Throwable t) throws Exception {
            HttpResponseException hre;
            if (Preconditions.checkNotNull((Object)t, (Object)"throwable") instanceof HttpResponseException ? (hre = (HttpResponseException)HttpResponseException.class.cast(t)).getResponse().getStatusCode() == 503 || hre.getResponse().getStatusCode() == 401 || MESSAGE_PATTERN.matcher(hre.getMessage()).matches() : t instanceof AuthorizationException) {
                return null;
            }
            throw Throwables.propagate((Throwable)t);
        }
    }
}

