/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Catalog;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

@Singleton
public class OrgNameCatalogNameItemNameToEndpoint
implements MapBinder {
    private final Supplier<Map<String, Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Catalog>>> orgCatalogMap;
    private final Supplier<ReferenceType> defaultOrg;
    private final Supplier<ReferenceType> defaultCatalog;

    @Inject
    public OrgNameCatalogNameItemNameToEndpoint(Supplier<Map<String, Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Catalog>>> orgCatalogMap, @Org Supplier<ReferenceType> defaultOrg, @Catalog Supplier<ReferenceType> defaultCatalog) {
        this.orgCatalogMap = orgCatalogMap;
        this.defaultOrg = defaultOrg;
        this.defaultCatalog = defaultCatalog;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Object org = postParams.get("orgName");
        Object catalog = postParams.get("catalogName");
        Object catalogItem = postParams.get("itemName");
        if (org == null) {
            org = ((ReferenceType)this.defaultOrg.get()).getName();
        }
        if (catalog == null) {
            catalog = ((ReferenceType)this.defaultCatalog.get()).getName();
        }
        try {
            Map catalogs = (Map)Preconditions.checkNotNull(((Map)this.orgCatalogMap.get()).get(org));
            return (R)request.toBuilder().endpoint(((ReferenceType)((org.jclouds.trmk.vcloud_0_8.domain.Catalog)catalogs.get(catalog)).get(catalogItem)).getHref()).build();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + "/" + catalog + "/" + catalogItem + " not found in " + this.orgCatalogMap.get());
        }
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException(this.getClass() + " needs parameters");
    }
}

