/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ssh.SshKeys;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.functions.CreateUniqueKeyPair;
import org.jclouds.trmk.vcloud_0_8.compute.options.TerremarkVCloudTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.domain.KeyPair;

@Singleton
public class CreateNewKeyPairUnlessUserSpecifiedOtherwise {
    final Map<String, Credentials> credentialStore;
    @VisibleForTesting
    final CreateUniqueKeyPair createUniqueKeyPair;

    @Inject
    CreateNewKeyPairUnlessUserSpecifiedOtherwise(Map<String, Credentials> credentialStore, CreateUniqueKeyPair createUniqueKeyPair) {
        this.credentialStore = credentialStore;
        this.createUniqueKeyPair = createUniqueKeyPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void execute(URI org, String group, String identity, TerremarkVCloudTemplateOptions options) {
        String sshKeyFingerprint = options.getSshKeyFingerprint();
        boolean shouldAutomaticallyCreateKeyPair = options.shouldAutomaticallyCreateKeyPair();
        if (sshKeyFingerprint == null && shouldAutomaticallyCreateKeyPair) {
            Map<String, Credentials> map = this.credentialStore;
            synchronized (map) {
                if (this.credentialStore.containsKey("group#" + group)) {
                    LoginCredentials creds = LoginCredentials.fromCredentials((Credentials)this.credentialStore.get("group#" + group));
                    Preconditions.checkState((boolean)creds.getOptionalPrivateKey().isPresent(), (String)"incorrect state: should have private key for: %s", (Object[])new Object[]{creds});
                    options.sshKeyFingerprint(SshKeys.fingerprintPrivateKey((String)creds.getPrivateKey()));
                } else {
                    KeyPair keyPair = this.createUniqueKeyPair.apply(new OrgAndName(org, group));
                    this.credentialStore.put("group#" + group, (Credentials)LoginCredentials.builder().user(identity).privateKey(keyPair.getPrivateKey()).build());
                    options.sshKeyFingerprint(keyPair.getFingerPrint());
                }
            }
        }
    }
}

