/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;

@Singleton
public class TerremarkVCloudGetImageStrategy
implements GetImageStrategy {
    protected final TerremarkVCloudClient client;
    protected final Function<VAppTemplate, Image> vAppToImage;

    @Inject
    protected TerremarkVCloudGetImageStrategy(TerremarkVCloudClient client, Function<VAppTemplate, Image> vAppToImage) {
        this.client = (TerremarkVCloudClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.vAppToImage = vAppToImage;
    }

    public Image getImage(String in) {
        URI id = URI.create(in);
        VAppTemplate from = this.client.getVAppTemplate(id);
        if (from == null) {
            return null;
        }
        return (Image)this.vAppToImage.apply((Object)from);
    }
}

