/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.domain.Task;

@Singleton
public class TerremarkVCloudLifeCycleStrategy
implements RebootNodeStrategy,
ResumeNodeStrategy,
SuspendNodeStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final TerremarkVCloudClient client;
    protected final Predicate<URI> taskTester;
    protected final GetNodeMetadataStrategy getNode;

    @Inject
    protected TerremarkVCloudLifeCycleStrategy(TerremarkVCloudClient client, Predicate<URI> taskTester, GetNodeMetadataStrategy getNode) {
        this.client = client;
        this.taskTester = taskTester;
        this.getNode = getNode;
    }

    public NodeMetadata rebootNode(String in) {
        Task task = this.client.resetVApp(URI.create((String)Preconditions.checkNotNull((Object)in, (Object)"node.id")));
        return this.returnWhenTaskCompletes(in, task);
    }

    private NodeMetadata returnWhenTaskCompletes(String in, Task task) {
        this.taskTester.apply((Object)task.getHref());
        return this.getNode.getNode(in);
    }

    public NodeMetadata resumeNode(String in) {
        Task task = this.client.powerOnVApp(URI.create((String)Preconditions.checkNotNull((Object)in, (Object)"node.id")));
        return this.returnWhenTaskCompletes(in, task);
    }

    public NodeMetadata suspendNode(String in) {
        Task task = this.client.powerOffVApp(URI.create((String)Preconditions.checkNotNull((Object)in, (Object)"node.id")));
        return this.returnWhenTaskCompletes(in, task);
    }
}

