/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.suppliers;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.internal.VolumeImpl;

@Singleton
public class StaticHardwareSupplier
implements Supplier<Set<? extends Hardware>> {
    public Set<? extends Hardware> get() {
        HashSet hardware = Sets.newHashSet();
        for (int cpus : new int[]{1, 2, 4, 8}) {
            for (int ram : new int[]{512, 1024, 2048, 4096, 8192, 16384}) {
                String id = String.format("cpu=%d,ram=%s,disk=%d", cpus, ram, 10);
                hardware.add(new HardwareBuilder().ids(id).ram(ram).processors((Iterable)ImmutableList.of((Object)new Processor((double)cpus, 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(10.0f), true, true))).hypervisor("VMware").build());
            }
        }
        return hardware;
    }
}

