/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain.internal;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;

public class CatalogImpl
extends LinkedHashMap<String, ReferenceType>
implements Catalog {
    private final String name;
    private final String type;
    private final URI href;
    @Nullable
    private final String description;

    public CatalogImpl(String name, String type, URI href, @Nullable String description, Map<String, ReferenceType> contents) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.description = description;
        this.href = (URI)Preconditions.checkNotNull((Object)href, (Object)"href");
        this.putAll((Map)Preconditions.checkNotNull(contents, (Object)"contents"));
    }

    @Override
    public URI getHref() {
        return this.href;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogImpl other = (CatalogImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public int compareTo(ReferenceType o) {
        return this == o ? 0 : this.getHref().compareTo(o.getHref());
    }
}

