/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;

public class CatalogItemImpl
extends ReferenceTypeImpl
implements CatalogItem {
    protected final String description;
    protected final ReferenceType entity;
    protected final Map<String, String> properties = Maps.newLinkedHashMap();
    private final ReferenceType computeOptions;
    private final ReferenceType customizationOptions;

    public CatalogItemImpl(String name, URI id, String description, ReferenceType computeOptions, ReferenceType customizationOptions, ReferenceType entity, Map<String, String> properties) {
        super(name, "application/vnd.vmware.vcloud.catalogItem+xml", id);
        this.description = description;
        this.entity = (ReferenceType)Preconditions.checkNotNull((Object)entity, (Object)"entity");
        this.properties.putAll((Map)Preconditions.checkNotNull(properties, (Object)"properties"));
        this.computeOptions = computeOptions;
        this.customizationOptions = customizationOptions;
    }

    @Override
    public String getType() {
        return "application/vnd.vmware.vcloud.catalogItem+xml";
    }

    @Override
    public ReferenceType getEntity() {
        return this.entity;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public ReferenceType getComputeOptions() {
        return this.computeOptions;
    }

    @Override
    public ReferenceType getCustomizationOptions() {
        return this.customizationOptions;
    }

    @Override
    public String toString() {
        return "[id=" + this.getHref() + ", name=" + this.getName() + ", type=" + this.getType() + ", description=" + this.getDescription() + ", entity=" + this.entity + ", computeOptions=" + this.computeOptions + ", customizationOptions=" + this.customizationOptions + ", properties=" + this.properties + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.computeOptions == null ? 0 : this.computeOptions.hashCode());
        result = 31 * result + (this.customizationOptions == null ? 0 : this.customizationOptions.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogItemImpl other = (CatalogItemImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.computeOptions == null ? other.computeOptions != null : !this.computeOptions.equals(other.computeOptions)) {
            return false;
        }
        return !(this.customizationOptions == null ? other.customizationOptions != null : !this.customizationOptions.equals(other.customizationOptions));
    }
}

