/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;

public class OrgImpl
extends ReferenceTypeImpl
implements Org {
    @Nullable
    private final String description;
    private final Map<String, ReferenceType> catalogs;
    private final Map<String, ReferenceType> vdcs;
    private final ReferenceType keys;
    private final ImmutableMap<String, ReferenceType> tasksLists;

    public OrgImpl(String name, String type, URI id, String description, Map<String, ReferenceType> catalogs, Map<String, ReferenceType> vdcs, Map<String, ReferenceType> tasksLists, ReferenceType keys) {
        super(name, type, id);
        this.description = description;
        this.catalogs = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(catalogs, (Object)"catalogs")));
        this.vdcs = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(vdcs, (Object)"vdcs")));
        this.tasksLists = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(tasksLists, (Object)"tasksLists")));
        this.keys = (ReferenceType)Preconditions.checkNotNull((Object)keys, (Object)"keys");
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, ReferenceType> getCatalogs() {
        return this.catalogs;
    }

    @Override
    public Map<String, ReferenceType> getVDCs() {
        return this.vdcs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.catalogs == null ? 0 : this.catalogs.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        result = 31 * result + (this.tasksLists == null ? 0 : this.tasksLists.hashCode());
        result = 31 * result + (this.vdcs == null ? 0 : this.vdcs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrgImpl other = (OrgImpl)obj;
        if (this.catalogs == null ? other.catalogs != null : !this.catalogs.equals(other.catalogs)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.keys == null ? other.keys != null : !this.keys.equals(other.keys)) {
            return false;
        }
        if (this.tasksLists == null ? other.tasksLists != null : !this.tasksLists.equals(other.tasksLists)) {
            return false;
        }
        return !(this.vdcs == null ? other.vdcs != null : !this.vdcs.equals(other.vdcs));
    }

    @Override
    public int compareTo(ReferenceType o) {
        return this == o ? 0 : this.getHref().compareTo(o.getHref());
    }

    @Override
    public String toString() {
        return "[href=" + this.getHref() + ", name=" + this.getName() + ", type=" + this.getType() + ", description=" + this.description + ", catalogs=" + this.catalogs + ", tasksLists=" + this.tasksLists + ", vdcs=" + this.vdcs + ", keys=" + this.keys + "]";
    }

    @Override
    public Map<String, ReferenceType> getTasksLists() {
        return this.tasksLists;
    }

    @Override
    public ReferenceType getKeys() {
        return this.keys;
    }
}

