/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;

@Singleton
public class AllCatalogsInOrg
implements Function<Org, Iterable<? extends Catalog>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    AllCatalogsInOrg(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<? extends Catalog> apply(Org org) {
        return FutureIterables.transformParallel(org.getCatalogs().values(), (Function)new Function<ReferenceType, ListenableFuture<? extends Catalog>>(){

            public ListenableFuture<? extends Catalog> apply(ReferenceType from) {
                return AllCatalogsInOrg.this.aclient.getCatalog(from.getHref());
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)("catalogs in " + org.getName()));
    }
}

