/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;

@Singleton
public class AllVDCsInOrg
implements Function<Org, Iterable<? extends VDC>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    AllVDCsInOrg(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<? extends VDC> apply(Org org) {
        return FutureIterables.transformParallel(org.getVDCs().values(), (Function)new Function<ReferenceType, ListenableFuture<? extends VDC>>(){

            public ListenableFuture<? extends VDC> apply(ReferenceType from) {
                return AllVDCsInOrg.this.aclient.getVDC(from.getHref());
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)("vdcs in org " + org.getName()));
    }
}

