/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.Org;

@Singleton
public class OrgsForLocations
implements Function<Iterable<? extends Location>, Iterable<? extends Org>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    OrgsForLocations(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<? extends Org> apply(Iterable<? extends Location> from) {
        return FutureIterables.transformParallel((Iterable)Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter(from, (Predicate)new Predicate<Location>(){

            public boolean apply(Location input) {
                return input.getScope() == LocationScope.ZONE;
            }
        }), (Function)new Function<Location, URI>(){

            public URI apply(Location from) {
                return URI.create(from.getParent().getId());
            }
        })), (Function)new Function<URI, ListenableFuture<? extends Org>>(){

            public ListenableFuture<? extends Org> apply(URI from) {
                return OrgsForLocations.this.aclient.getOrg(from);
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)"organizations for uris");
    }
}

