/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;

@Singleton
public class VAppTemplatesForCatalogItems
implements Function<Iterable<? extends CatalogItem>, Iterable<? extends VAppTemplate>> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    VAppTemplatesForCatalogItems(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<? extends VAppTemplate> apply(Iterable<? extends CatalogItem> from) {
        return FutureIterables.transformParallel((Iterable)Iterables.filter(from, (Predicate)new Predicate<CatalogItem>(){

            public boolean apply(CatalogItem input) {
                return input.getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml");
            }
        }), (Function)new Function<CatalogItem, ListenableFuture<? extends VAppTemplate>>(){

            public ListenableFuture<? extends VAppTemplate> apply(CatalogItem from) {
                return VAppTemplatesForCatalogItems.this.aclient.getVAppTemplate(from.getEntity().getHref());
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)"vappTemplates in");
    }
}

