/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;

@Singleton
public class VAppTemplatesForResourceEntities
implements Function<Iterable<? extends ReferenceType>, Iterable<? extends VAppTemplate>> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    VAppTemplatesForResourceEntities(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<? extends VAppTemplate> apply(Iterable<? extends ReferenceType> from) {
        return FutureIterables.transformParallel((Iterable)Iterables.filter((Iterable)((Iterable)Preconditions.checkNotNull(from, (Object)"named resources")), (Predicate)new Predicate<ReferenceType>(){

            public boolean apply(ReferenceType input) {
                return input.getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml");
            }
        }), (Function)new Function<ReferenceType, ListenableFuture<? extends VAppTemplate>>(){

            public ListenableFuture<? extends VAppTemplate> apply(ReferenceType from) {
                return VAppTemplatesForResourceEntities.this.aclient.getVAppTemplate(from.getHref());
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)"vappTemplates in");
    }
}

