/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.util;

import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudError;
import org.jclouds.trmk.vcloud_0_8.xml.ErrorHandler;

@Singleton
public class VCloudUtils {
    private final ParseSax.Factory factory;
    private final Provider<ErrorHandler> errorHandlerProvider;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    VCloudUtils(ParseSax.Factory factory, Provider<ErrorHandler> errorHandlerProvider) {
        this.factory = factory;
        this.errorHandlerProvider = errorHandlerProvider;
    }

    public VCloudError parseErrorFromContent(HttpRequest request, HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        if ("application/vnd.vmware.vcloud.error+xml".equals(response.getPayload().getContentMetadata().getContentType())) {
            try {
                return (VCloudError)this.factory.create((ParseSax.HandlerWithResult)this.errorHandlerProvider.get()).setContext(request).apply(response);
            }
            catch (RuntimeException e) {
                this.logger.warn((Throwable)e, "error parsing error", new Object[0]);
            }
        }
        return null;
    }
}

