/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import java.util.Map;
import javax.annotation.Resource;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.FenceMode;
import org.jclouds.trmk.vcloud_0_8.domain.Network;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.internal.NetworkImpl;
import org.jclouds.trmk.vcloud_0_8.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NetworkHandler
extends ParseSax.HandlerWithResult<Network> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected StringBuilder currentText = new StringBuilder();
    protected ReferenceType network;
    protected String description;
    protected String gateway;
    protected String netmask;
    protected FenceMode fenceMode;
    private ReferenceType ips;
    private ReferenceType extension;

    public Network getResult() {
        return new NetworkImpl(this.network.getName(), this.network.getType(), this.network.getHref(), this.description, this.gateway, this.netmask, this.fenceMode, this.extension, this.ips);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (qName.equals("Network")) {
            this.network = Utils.newReferenceType(attributes);
        } else if (qName.equals("Link")) {
            if ("IP Addresses".equals(attributes.get("name"))) {
                this.ips = Utils.newReferenceType(attributes);
            } else if ("down".equals(attributes.get("rel"))) {
                this.extension = Utils.newReferenceType(attributes);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Description")) {
            this.description = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Gateway")) {
            this.gateway = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Netmask")) {
            this.netmask = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("FenceMode")) {
            this.fenceMode = FenceMode.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

