/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import java.net.URI;
import javax.annotation.Resource;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.Node;

public class NodeHandler
extends ParseSax.HandlerWithResult<Node> {
    @Resource
    protected Logger logger = Logger.NULL;
    private StringBuilder currentText = new StringBuilder();
    private URI location;
    private String serviceName;
    private String address;
    private int port;
    private String description;
    private boolean enabled;

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }

    public Node getResult() {
        return new Node(this.serviceName, this.location, this.address, this.port, this.enabled, this.description);
    }

    public void endElement(String uri, String name, String qName) {
        String current = this.currentOrNull();
        if (current != null) {
            if (qName.equals("Href")) {
                this.location = URI.create(current);
            } else if (qName.equals("Name")) {
                this.serviceName = current;
            } else if (qName.equals("Port")) {
                this.port = Integer.parseInt(current);
            } else if (qName.equals("Enabled")) {
                this.enabled = Boolean.parseBoolean(current);
            } else if (qName.equals("IpAddress")) {
                this.address = current;
            } else if (qName.equals("Description")) {
                this.description = current;
            }
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

