/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gae;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.repackaged.com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Date;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateServiceDateCodecFactory;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.encryption.internal.JCECrypto;
import org.jclouds.gae.ConvertToGaeRequest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.Payloads;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test
public class ConvertToGaeRequestTest {
    ConvertToGaeRequest req;
    URI endPoint;
    protected static volatile Crypto crypto;

    @BeforeTest
    void setupClient() {
        this.endPoint = URI.create("http://localhost:80/foo");
        this.req = new ConvertToGaeRequest(new HttpUtils(0, 0, 0, 0), (ContentMetadataCodec)new ContentMetadataCodec.DefaultContentMetadataCodec((DateCodecFactory)new DateServiceDateCodecFactory((DateService)new SimpleDateFormatDateService())));
    }

    @Test
    void testConvertRequestGetsTargetAndUri() throws IOException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(this.endPoint).build();
        HTTPRequest gaeRequest = this.req.apply(request);
        Assert.assertEquals((String)gaeRequest.getURL().getPath(), (String)"/foo");
    }

    @Test
    void testConvertRequestSetsFetchOptions() throws IOException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(this.endPoint).build();
        HTTPRequest gaeRequest = this.req.apply(request);
        assert (gaeRequest.getFetchOptions() != null);
    }

    @Test
    void testConvertRequestSetsHeaders() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(this.endPoint).addHeader("foo", new String[]{"bar"})).build();
        HTTPRequest gaeRequest = this.req.apply(request);
        Assert.assertEquals((String)((HTTPHeader)gaeRequest.getHeaders().get(0)).getName(), (String)"foo");
        Assert.assertEquals((String)((HTTPHeader)gaeRequest.getHeaders().get(0)).getValue(), (String)"bar");
    }

    @Test
    void testConvertRequestNoContent() throws IOException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(this.endPoint).build();
        HTTPRequest gaeRequest = this.req.apply(request);
        assert (gaeRequest.getPayload() == null);
        Assert.assertEquals((int)gaeRequest.getHeaders().size(), (int)1);
        Assert.assertEquals((String)((HTTPHeader)gaeRequest.getHeaders().get(0)).getName(), (String)"User-Agent");
        Assert.assertEquals((String)((HTTPHeader)gaeRequest.getHeaders().get(0)).getValue(), (String)"jclouds/1.0 urlfetch/1.4.3");
    }

    @Test
    void testConvertRequestStringContent() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(this.endPoint).payload("hoot!")).build();
        this.testHoot(request);
    }

    @Test
    void testConvertRequestInputStreamContent() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(this.endPoint).payload(Strings2.toInputStream((String)"hoot!"))).build();
        request.getPayload().getContentMetadata().setContentLength(Long.valueOf(5L));
        this.testHoot(request);
    }

    @Test
    void testConvertRequestBytesContent() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(this.endPoint).payload("hoot!".getBytes())).build();
        this.testHoot(request);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    void testConvertRequestBadContent() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(this.endPoint).payload(Payloads.newPayload((Object)new Date()))).build();
        this.req.apply(request);
    }

    @Test
    @Parameters(value={"basedir"})
    void testConvertRequestFileContent(String basedir) throws IOException {
        File file = new File(basedir, "target/testfiles/hoot");
        file.getParentFile().mkdirs();
        Files.write((byte[])"hoot!".getBytes(Charsets.UTF_8), (File)file);
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(this.endPoint).payload(file)).build();
        this.testHoot(request);
    }

    private void testHoot(HttpRequest request) throws IOException {
        request.getPayload().getContentMetadata().setContentType("text/plain");
        request.getPayload().getContentMetadata().setContentMD5(new byte[]{1, 2, 3, 4});
        HTTPRequest gaeRequest = this.req.apply(request);
        StringBuilder builder = new StringBuilder();
        for (HTTPHeader header : gaeRequest.getHeaders()) {
            builder.append(header.getName()).append(": ").append(header.getValue()).append("\n");
        }
        Assert.assertEquals((String)builder.toString(), (String)"User-Agent: jclouds/1.0 urlfetch/1.4.3\nExpect: 100-continue\nContent-Type: text/plain\nContent-MD5: AQIDBA==\n");
        Assert.assertEquals((String)new String(gaeRequest.getPayload()), (String)"hoot!");
    }

    static {
        try {
            crypto = new JCECrypto();
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (CertificateException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

