/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gae;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import org.easymock.EasyMock;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateServiceDateCodecFactory;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.encryption.internal.JCECrypto;
import org.jclouds.gae.ConvertToJcloudsResponse;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test
public class ConvertToJcloudsResponseTest {
    ConvertToJcloudsResponse req;
    URI endPoint;
    protected static volatile Crypto crypto;

    @BeforeTest
    void setupClient() {
        this.endPoint = URI.create("http://localhost:80/foo");
        this.req = new ConvertToJcloudsResponse((ContentMetadataCodec)new ContentMetadataCodec.DefaultContentMetadataCodec((DateCodecFactory)new DateServiceDateCodecFactory((DateService)new SimpleDateFormatDateService())));
    }

    @Test
    void testConvertHostHeaderToEndPoint() {
    }

    @Test
    void testConvertWithHeaders() throws IOException {
        HTTPResponse gaeResponse = (HTTPResponse)EasyMock.createMock(HTTPResponse.class);
        EasyMock.expect((Object)gaeResponse.getResponseCode()).andReturn((Object)200);
        ArrayList headers = Lists.newArrayList();
        headers.add(new HTTPHeader("Content-Type", "text/xml"));
        EasyMock.expect((Object)gaeResponse.getHeaders()).andReturn((Object)headers);
        EasyMock.expect((Object)gaeResponse.getContent()).andReturn(null).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{gaeResponse});
        HttpResponse response = this.req.apply(gaeResponse);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        Assert.assertEquals((Object)response.getPayload(), null);
        Assert.assertEquals((int)response.getHeaders().size(), (int)0);
    }

    @Test
    void testConvertWithContent() throws IOException {
        HTTPResponse gaeResponse = (HTTPResponse)EasyMock.createMock(HTTPResponse.class);
        EasyMock.expect((Object)gaeResponse.getResponseCode()).andReturn((Object)200);
        ArrayList headers = Lists.newArrayList();
        headers.add(new HTTPHeader("Content-Type", "text/xml"));
        EasyMock.expect((Object)gaeResponse.getHeaders()).andReturn((Object)headers);
        EasyMock.expect((Object)gaeResponse.getContent()).andReturn((Object)"hello".getBytes()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{gaeResponse});
        HttpResponse response = this.req.apply(gaeResponse);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        Assert.assertEquals((String)Strings2.toString((InputSupplier)response.getPayload()), (String)"hello");
        Assert.assertEquals((int)response.getHeaders().size(), (int)0);
        Assert.assertEquals((String)response.getPayload().getContentMetadata().getContentType(), (String)"text/xml");
    }

    static {
        try {
            crypto = new JCECrypto();
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (CertificateException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

