/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gae;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closeables;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;

@Singleton
public class ConvertToGaeRequest
implements Function<HttpRequest, HTTPRequest> {
    public static final String USER_AGENT = "jclouds/1.0 urlfetch/1.4.3";
    public final Set<String> prohibitedHeaders = ImmutableSet.of((Object)"Accept-Encoding", (Object)"Content-Length", (Object)"Host", (Object)"Var", (Object)"X-Forwarded-For");
    protected final HttpUtils utils;
    protected final ContentMetadataCodec contentMetadataCodec;

    @Inject
    ConvertToGaeRequest(HttpUtils utils, ContentMetadataCodec contentMetadataCodec) {
        this.utils = utils;
        this.contentMetadataCodec = contentMetadataCodec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPRequest apply(HttpRequest request) {
        URL url = null;
        try {
            url = request.getEndpoint().toURL();
        }
        catch (MalformedURLException e) {
            Throwables.propagate((Throwable)e);
        }
        FetchOptions options = FetchOptions.Builder.disallowTruncate();
        options.doNotFollowRedirects();
        if (this.utils.relaxHostname() || this.utils.trustAllCerts()) {
            options.doNotFollowRedirects();
        }
        options.setDeadline(Double.valueOf(10.0));
        HTTPRequest gaeRequest = new HTTPRequest(url, HTTPMethod.valueOf((String)request.getMethod().toString()), options);
        for (Map.Entry entry : request.getHeaders().entries()) {
            Object header = (String)entry.getKey();
            if (this.prohibitedHeaders.contains(header)) continue;
            gaeRequest.addHeader(new HTTPHeader((String)header, (String)entry.getValue()));
        }
        gaeRequest.addHeader(new HTTPHeader("User-Agent", USER_AGENT));
        if (request.getPayload() != null) {
            InputStream input = request.getPayload().getInput();
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                request.getPayload().writeTo((OutputStream)out);
                byte[] array = out.toByteArray();
                if (!request.getPayload().isRepeatable()) {
                    Payload oldPayload = request.getPayload();
                    request.setPayload(array);
                    HttpUtils.copy((ContentMetadata)oldPayload.getContentMetadata(), (MutableContentMetadata)request.getPayload().getContentMetadata());
                }
                gaeRequest.setPayload(array);
                if (array.length > 0) {
                    gaeRequest.setHeader(new HTTPHeader("Expect", "100-continue"));
                }
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            finally {
                Closeables.closeQuietly((Closeable)input);
            }
            for (Object header : this.contentMetadataCodec.toHeaders((ContentMetadata)request.getPayload().getContentMetadata()).entries()) {
                if (this.prohibitedHeaders.contains(header.getKey())) continue;
                gaeRequest.setHeader(new HTTPHeader((String)header.getKey(), (String)header.getValue()));
            }
        }
        return gaeRequest;
    }
}

