/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gae;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.common.base.Function;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteArrayPayload;

@Singleton
public class ConvertToJcloudsResponse
implements Function<HTTPResponse, HttpResponse> {
    private final ContentMetadataCodec contentMetadataCodec;

    @Inject
    public ConvertToJcloudsResponse(ContentMetadataCodec contentMetadataCodec) {
        this.contentMetadataCodec = contentMetadataCodec;
    }

    public HttpResponse apply(HTTPResponse gaeResponse) {
        ByteArrayPayload payload = gaeResponse.getContent() != null ? Payloads.newByteArrayPayload((byte[])gaeResponse.getContent()) : null;
        LinkedHashMultimap headers = LinkedHashMultimap.create();
        String message = null;
        for (HTTPHeader header : gaeResponse.getHeaders()) {
            if (header.getName() == null) {
                message = header.getValue();
                continue;
            }
            headers.put((Object)header.getName(), (Object)header.getValue());
        }
        if (payload != null) {
            this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), (Multimap)headers);
        }
        return ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(gaeResponse.getResponseCode()).message(message).payload((Payload)payload)).headers(HttpUtils.filterOutContentHeaders((Multimap)headers))).build();
    }
}

