/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gae;

import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.JcloudsVersion;
import org.jclouds.concurrent.SingleThreaded;
import org.jclouds.gae.ConvertToGaeRequest;
import org.jclouds.gae.ConvertToJcloudsResponse;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadataCodec;

@SingleThreaded
@Singleton
public class GaeHttpCommandExecutorService
extends BaseHttpCommandExecutorService<HTTPRequest> {
    public static final String USER_AGENT = String.format("jclouds/%s urlfetch/%s", JcloudsVersion.get(), "1.6.5");
    private final URLFetchService urlFetchService;
    private final ConvertToGaeRequest convertToGaeRequest;
    private final ConvertToJcloudsResponse convertToJcloudsResponse;

    @Inject
    public GaeHttpCommandExecutorService(URLFetchService urlFetchService, HttpUtils utils, ContentMetadataCodec contentMetadataCodec, @Named(value="jclouds.io-worker-threads") ListeningExecutorService ioExecutor, IOExceptionRetryHandler ioRetryHandler, DelegatingRetryHandler retryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, ConvertToGaeRequest convertToGaeRequest, ConvertToJcloudsResponse convertToJcloudsResponse) {
        super(utils, contentMetadataCodec, ioExecutor, retryHandler, ioRetryHandler, errorHandler, wire);
        this.urlFetchService = urlFetchService;
        this.convertToGaeRequest = convertToGaeRequest;
        this.convertToJcloudsResponse = convertToJcloudsResponse;
    }

    @VisibleForTesting
    protected HttpResponse convert(HTTPResponse gaeResponse) {
        return this.convertToJcloudsResponse.apply(gaeResponse);
    }

    @VisibleForTesting
    protected HTTPRequest convert(HttpRequest request) throws IOException {
        return this.convertToGaeRequest.apply(request);
    }

    protected void cleanup(HTTPRequest nativeRequest) {
    }

    protected HttpResponse invoke(HTTPRequest request) throws IOException {
        return this.convert(this.urlFetchService.fetch(request));
    }
}

