/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.joda;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Date;
import org.jclouds.date.DateService;
import org.jclouds.date.DateServiceTest;
import org.jclouds.date.joda.JodaDateService;
import org.jclouds.date.joda.config.JodaDateServiceModule;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"performance"}, singleThreaded=true, timeOut=120000L, testName="JodaDateServiceTest")
public class JodaDateServiceTest
extends DateServiceTest {
    @BeforeTest
    protected void createDateService() {
        Injector i = Guice.createInjector((Module[])new Module[]{new JodaDateServiceModule()});
        this.dateService = (DateService)i.getInstance(DateService.class);
        assert (this.dateService instanceof JodaDateService);
    }

    @Test
    public void testRfc822DateFormat() {
        String dsString = this.dateService.rfc822DateFormat(this.testData[0].date);
        Assert.assertEquals((String)dsString, (String)this.testData[0].rfc822DateString);
    }

    @Test(enabled=false)
    public void testRfc822DateParse() {
        Date dsDate = this.dateService.rfc822DateParse(this.testData[0].rfc822DateString);
        Assert.assertEquals((Object)dsDate, (Object)this.testData[0].date);
    }
}

